<?php

namespace Drupal\mautic_eca;

use Drupal\eca\Event\BaseHookHandler;

/**
 * The handler for hook implementations within the mautic_eca module.
 *
 * @internal
 *   This class is not meant to be used as a public API. It is subject for
 *   name change or may be removed completely, also on minor version updates.
 *
 * @deprecated in eca:3.0.0 and is removed from eca:3.1.0. Procedural hooks
 *   should be converted into proper event/listener classes. This class
 *   currently extends the deprecated Drupal\eca\Event\BaseHookHandler and
 *   relies on its $triggerEvent property.
 * @see https://www.drupal.org/project/mautic_eca/issues/3550474
 *
 * @phpstan-ignore-next-line - extends deprecated class (eca:3.0.0 -> removed in
 * eca:3.1.0). See https://www.drupal.org/project/mautic_eca/issues/3550474
 */
class HookHandler extends BaseHookHandler {

  /**
   * Triggers the event for when a Mautic webhook is received.
   *
   * @param array $data
   *   The webhook data from Mautic.
   *
   * @deprecated in eca:3.0.0 and is removed from eca:3.1.0. Accesses
   *   $this->triggerEvent from the deprecated
   *   Drupal\eca\Event\BaseHookHandler. Convert procedural hook
   *   implementation into a dedicated event handler class.
   * @see https://www.drupal.org/project/mautic_eca/issues/3550474
   */
  public function webhookReceived(array $data): void {
    // Accessing $this->triggerEvent on the deprecated base class.
    // @phpstan-ignore-line - accessing deprecated property on BaseHookHandler
    $this->triggerEvent->dispatchFromPlugin(
      'mautic_webhook_eca:webhook_received',
      $data
    );
  }

}
