# Introduction

MaxLength allows site administrators to set hard or soft character 
limits on titles, text fields, and links.

For a full description of the module visit the [MaxLength Project Page](https://www.drupal.org/project/maxlength)

# Contributing

We appreciate contributions of all kind for the project.

If you haven't already, familiarize yourself with [Drupal's Code of Conduct](https://www.drupal.org/dcoc). 

We design improvements and prioritize issues based on our vision and values.

## Vision

The MaxLength module helps website authors write concisely 
to better connect with their audiences and adhere 
to the character limits defined by the site's design.


## Values 

The MaxLength module is designed to be:

* **helpful** for authors
* **intuitive** for site builders
* **sustainable** for site owners
* **extendable** for developers

## Roadmap

Visit our [Roadmap](https://www.drupal.org/project/maxlength/issues/3259874) to see which issues are a priority and in need of assistance.

## Reporting Bugs and Requesting Features

* To submit bug reports and feature suggestions, 
  visit https://www.drupal.org/project/issues/maxlength


# Requirements

This module requires no modules outside of Drupal core.


# Installation

Install the MaxLength module as you would normally 
install a contributed Drupal module. 
Read the [Installing Modules documentation page](https://www.drupal.org/node/1897420) for more information.


# Configuration

1. Navigate to Administration > Extend and enable the module.
2. Navigate to Administration > Structure > Content types [Content type to edit] 
3. Then Navigate to Content types > Manage form display.
4. Select the contextual links icon for the desired field and enter MaxLength. 
5. Update and save.

For more information read the [MaxLength Documentation](https://www.drupal.org/docs/contributed-modules/maxlength). 

# Maintainers

 * [Clayton Dewey (cedewey)](https://www.drupal.org/u/cedewey)
 * [Jeff Hipp (hipp2bsquare)](https://www.drupal.org/u/hipp2bsquare)
 * [Steven DuBois(srdtwc)](https://www.drupal.org/u/srdtwc)
 * [Adam Nagy(joevagyok)](https://www.drupal.org/u/joevagyok)

Supporting organizations:

 * [DevCollaborative](https://devcollaborative.com)
 * [European Commission](https://www.drupal.org/european-commission)
 

# Credits

Many people have contributed to MaxLength over the years. 
We are grateful to each of them for the work they've put into it.

Read more about the history of MaxLength at the [Credits documentation page](https://www.drupal.org/docs/contributed-modules/maxlength/credits).
