<?php

declare(strict_types=1);

namespace Drupal\mcp_client\ValueObject;

/**
 * Represents the input schema for an MCP tool.
 */
interface InputSchemaInterface {

  /**
   * Converts the schema to an array representation.
   *
   * @return array<string, mixed>
   *   JSON Schema array.
   */
  public function toArray(): array;

  /**
   * Gets a property schema.
   *
   * @param string $name
   *   Property name.
   *
   * @return array<string, mixed>|null
   *   Property schema or null.
   */
  public function getProperty(string $name): ?array;

  /**
   * Gets all properties.
   *
   * @return array<string, mixed>
   *   Properties array.
   */
  public function getProperties(): array;

  /**
   * Checks if a property is required.
   *
   * @param string $name
   *   Property name.
   *
   * @return bool
   *   True if required.
   */
  public function isRequired(string $name): bool;

}
