<?php

declare(strict_types=1);

namespace Drupal\mcp_client\ValueObject;

/**
 * Collection interface with iteration and counting support.
 *
 * @extends \IteratorAggregate<string, \Drupal\mcp_client\ValueObject\ToolInterface>
 */
interface ToolCollectionInterface extends \IteratorAggregate, \Countable {

  /**
   * Gets a tool by name.
   *
   * @param string $name
   *   The tool name.
   *
   * @return \Drupal\mcp_client\ValueObject\ToolInterface|null
   *   The tool or null if not found.
   */
  public function get(string $name): ?ToolInterface;

  /**
   * Adds a tool to the collection.
   *
   * @param \Drupal\mcp_client\ValueObject\ToolInterface $tool
   *   The tool to add.
   */
  public function add(ToolInterface $tool): void;

  /**
   * Removes a tool from the collection.
   *
   * @param string $name
   *   The tool name.
   */
  public function remove(string $name): void;

  /**
   * Checks if a tool exists in the collection.
   *
   * @param string $name
   *   The tool name.
   *
   * @return bool
   *   True if exists, false otherwise.
   */
  public function has(string $name): bool;

  /**
   * Gets all tools as an array.
   *
   * @return ToolInterface[]
   *   Array of all tools.
   */
  public function all(): array;

  /**
   * Converts the collection to an array representation.
   *
   * @return array<int, array<string, mixed>>
   *   Array representation of the collection.
   */
  public function toArray(): array;

}
