<?php

declare(strict_types=1);

namespace Drupal\mcp_client\ValueObject;

use Drupal\tool\Tool\ToolOperation;

/**
 * Represents a single MCP tool with its configuration and metadata.
 */
interface ToolInterface {

  /**
   * Gets the tool name.
   *
   * @return string
   *   The tool name.
   */
  public function name(): string;

  /**
   * Gets the tool description.
   *
   * @return string
   *   The tool description.
   */
  public function description(): string;

  /**
   * Gets the tool input schema.
   *
   * @return InputSchemaInterface
   *   The input schema.
   */
  public function getInputSchema(): InputSchemaInterface;

  /**
   * Checks if the tool is enabled.
   *
   * @return bool
   *   True if enabled.
   */
  public function enabled(): bool;

  /**
   * Checks if the tool is locked.
   *
   * @return bool
   *   True if locked.
   */
  public function locked(): bool;

  /**
   * Gets the tool operation type.
   *
   * @return \Drupal\tool\Tool\ToolOperation|null
   *   The tool operations or null.
   */
  public function getOperation(): ?ToolOperation;

  /**
   * Gets the locked definition if tool is locked.
   *
   * @return LockedDefinitionInterface|null
   *   The locked definition or null.
   */
  public function getLockedDefinition(): ?LockedDefinitionInterface;

  /**
   * Creates a builder from this Tool instance.
   *
   * @return \Drupal\mcp_client\ValueObject\ToolBuilder
   *   A new builder initialized with this tool's values.
   */
  public function toBuilder(): ToolBuilder;

  /**
   * Converts the tool to an array representation.
   *
   * @return array<string, mixed>
   *   The Tool data as an associative array.
   */
  public function toArray(): array;

}
