---
id: 1
group: "foundation"
dependencies: []
status: "completed"
created: "2025-11-09"
skills:
  - "composer"
  - "drupal-backend"
---
# Add Tool API Module Dependency

## Objective
Add the Tool API module as a required dependency to mcp_server module and install it

## Skills Required
- composer: Package dependency management
- drupal-backend: Drupal module configuration

## Acceptance Criteria
- [ ] Tool API module added to composer.json with version constraint `^1.0`
- [ ] Tool API module added to mcp_server.info.yml dependencies
- [ ] Tool API module installed successfully via composer
- [ ] Tool API module enabled in Drupal
- [ ] Cache rebuilt after installation

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
- Update composer.json with `drupal/tool: ^1.0`
- Add `tool:tool` to dependencies in mcp_server.info.yml
- Run `composer require drupal/tool:^1.0` from project root (/var/www/html)
- Run `vendor/bin/drush pm:enable tool` to enable the module
- Run `vendor/bin/drush cache:rebuild`

## Input Dependencies
None - this is the foundation task

## Output Artifacts
- Updated composer.json
- Updated mcp_server.info.yml
- Tool API module installed and enabled
- Tool manager service available for use

## Implementation Notes
<details>
<summary>Detailed Steps</summary>

1. **Update composer.json** in the mcp_server module:
   - Add `"drupal/tool": "^1.0"` to the require section
   - Maintain alphabetical order of dependencies

2. **Update mcp_server.info.yml**:
   - Add `tool:tool` to the dependencies array
   - Follow format: `- tool:tool`

3. **Install via Composer** (run from /var/www/html):
   ```bash
   composer require drupal/tool:^1.0
   ```

4. **Enable the module**:
   ```bash
   vendor/bin/drush pm:enable tool -y
   ```

5. **Rebuild cache**:
   ```bash
   vendor/bin/drush cache:rebuild
   ```

6. **Verify installation**:
   ```bash
   vendor/bin/drush pm:list --status=enabled | grep tool
   ```

**Important**: Work from /var/www/html for composer and drush commands, but edit files in the module directory at /var/www/html/web/modules/contrib/mcp_server/
</details>
