---
id: 6
group: "quality"
dependencies: [4, 5]
status: "completed"
created: "2025-11-09"
skills:
  - "drupal-backend"
  - "testing"
---
# Integration Testing and Documentation

## Objective
Create integration tests that verify end-to-end Tool API to MCP tool flow and update README with usage instructions

## Skills Required
- drupal-backend: PHPUnit testing in Drupal, test module creation
- testing: Test design for integration scenarios

## Acceptance Criteria
- [ ] Test module created with sample Tool API tool
- [ ] Kernel test for mcp_tool_config entity CRUD
- [ ] Kernel test for ToolApiDiscovery service
- [ ] Functional test for admin UI
- [ ] Integration test for end-to-end MCP tool execution
- [ ] README.md updated with Tool API integration section
- [ ] Code examples added for common use cases
- [ ] All tests pass with `vendor/bin/phpunit`

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
- Test module location: tests/modules/mcp_server_test
- Test classes in tests/src/
- Test types:
  - Kernel tests for services and entities (faster)
  - Functional tests for UI
  - Integration test for complete flow
- README sections:
  - Tool API Integration overview
  - Installation steps
  - Creating mcp_tool_config entities
  - Admin UI usage
  - Example configurations
- Run from /var/www/html: `vendor/bin/phpunit web/modules/contrib/mcp_server`

## Input Dependencies
- Task 4: McpToolApiBridge must be implemented to test execution
- Task 5: Admin UI must be built to test forms

## Output Artifacts
- tests/modules/mcp_server_test/ - Test module with sample Tool API tool
- tests/src/Kernel/ - Kernel tests
- tests/src/Functional/ - Functional tests
- Updated README.md with comprehensive documentation
- All tests passing

## Implementation Notes
<details>
<summary>Detailed Steps</summary>

### IMPORTANT: Meaningful Test Strategy Guidelines

**Critical mantra**: "write a few tests, mostly integration"

**Focus on testing:**
- Custom business logic (schema conversion, entity CRUD)
- Critical user workflows (creating config, executing tool via MCP)
- Integration points (Tool API ↔ MCP Server bridge)
- Edge cases (invalid tool IDs, disabled tools, schema incompatibilities)

**Do NOT test:**
- Drupal core functionality (entity storage, form rendering)
- Tool API module functionality (tool execution, schema definitions)
- MCP SDK functionality (attribute discovery, tool registration)

**Combine related scenarios into single tests**:
- Test entity creation, loading, update, delete in one kernel test
- Test full admin UI workflow in one functional test
- Test complete MCP tool call flow (config → discovery → execution) in one integration test

### Step 1: Create Test Module

Create `tests/modules/mcp_server_test/`:

**mcp_server_test.info.yml**:
```yaml
name: 'MCP Server Test Tool'
type: module
description: 'Provides test Tool API tool for mcp_server testing'
package: Testing
core_version_requirement: ^10 || ^11
dependencies:
  - tool:tool
hidden: true
```

**mcp_server_test.services.yml**:
```yaml
services:
  mcp_server_test.example_tool:
    class: Drupal\mcp_server_test\ExampleTool
    tags:
      - { name: tool }
```

**src/ExampleTool.php**: Create a simple Tool API tool implementation for testing.

### Step 2: Create Kernel Tests

**tests/src/Kernel/McpToolConfigTest.php**:
- Test entity CRUD operations
- Test status field functionality
- Test configuration export/import
- Test loading by tool_id

**tests/src/Kernel/ToolApiDiscoveryTest.php**:
- Test getAvailableTools() returns test tool
- Test getToolDefinition() for valid/invalid IDs
- Test convertToMcpSchema() for various types
- Test executeTool() success and failure cases

**tests/src/Kernel/McpToolApiBridgeTest.php**:
- Test getConfiguredTools() returns enabled configs only
- Test disabled configs are filtered out
- Test schema conversion integration

### Step 3: Create Functional Test

**tests/src/Functional/McpToolConfigUiTest.php**:
- Test list page displays configs
- Test add form creates config
- Test autocomplete suggests tool IDs
- Test edit form updates config
- Test delete form removes config
- Test permission restrictions

### Step 4: Create Integration Test

**tests/src/Kernel/ToolApiMcpIntegrationTest.php**:
Complete end-to-end flow:
1. Create mcp_tool_config entity for test tool
2. Verify tool appears in MCP discovery
3. Execute tool via McpToolApiBridge
4. Verify result matches Tool API execution
5. Disable config and verify tool no longer appears
6. Test error handling (invalid tool ID, execution failure)

### Step 5: Run Tests

```bash
cd /var/www/html
vendor/bin/phpunit web/modules/contrib/mcp_server/tests/
```

Fix any failures before proceeding.

### Step 6: Update README.md

Add new section after "Creating MCP Capabilities":

```markdown
## Tool API Integration

The MCP Server module integrates with the [Tool API module](https://www.drupal.org/project/tool) to expose any Tool API tool as an MCP tool without requiring code modifications.

### Prerequisites

The Tool API module is a required dependency and will be installed automatically with mcp_server.

### Creating MCP Tool Configurations

Tool API tools are exposed to MCP via configuration entities. You can manage these through the admin UI or configuration management.

#### Via Admin UI

1. Navigate to `/admin/config/services/mcp-server/tools`
2. Click "Add MCP Tool Configuration"
3. Enter a label and machine name
4. Select a Tool API tool ID (autocomplete will suggest available tools)
5. Optionally override the MCP tool name and description
6. Ensure "Enabled" is checked
7. Save

#### Via Configuration

Create a config file in `config/sync/`:

```yaml
# config/sync/mcp_server.mcp_tool_config.example.yml
langcode: en
status: true
id: example
label: 'Example Tool'
tool_id: 'module_name:tool_name'
mcp_name: 'custom_name'
description: 'Custom description for AI context'
```

Then import:
```bash
drush config:import
drush cache:rebuild
```

### Example: Exposing a Custom Tool

If you have a Tool API tool defined in your custom module:

```php
// In my_module/src/Plugin/Tool/SendEmail.php
#[Tool(
  id: 'my_module:send_email',
  label: 'Send Email',
  description: 'Sends an email to a specified recipient'
)]
class SendEmail { ... }
```

Create an MCP configuration to expose it:

1. Admin UI: Add config with tool_id = `my_module:send_email`
2. The tool will now be available to MCP clients as an MCP tool
3. AI assistants can discover and call it via the MCP protocol

### Schema Conversion

Tool API's ContextDefinition types are automatically converted to MCP JSON Schema:
- `string` → `string`
- `integer` → `integer`
- `boolean` → `boolean`
- `entity_reference` → `string` (entity ID)

### Managing Tools

- **Enable/Disable**: Use the status field to control MCP exposure without deleting configs
- **Override Metadata**: Customize the tool name and description for AI context
- **Bulk Management**: Import/export configs via configuration management

### Security Considerations

- MCP tool configurations respect Tool API's own access controls
- Use the "Administer MCP tool configurations" permission to control who can expose tools
- Review which tools are appropriate for AI assistant access before enabling
```

### Step 7: Validate Documentation

- Ensure all code examples are accurate
- Verify paths and commands are correct
- Test following the documentation steps manually

**Remember**: Focus tests on YOUR integration code, not on Drupal/Tool API/MCP SDK functionality.
</details>
