---
id: 1
group: "entity-foundation"
dependencies: []
status: "completed"
created: "2025-11-09"
completed: "2025-11-09"
skills:
  - drupal-backend
  - php
---
# Add authentication_mode field to McpToolConfig entity

## Objective
Extend the McpToolConfig entity with an authentication_mode property that stores one of three values (required/optional/disabled) with proper validation and helper methods.

## Skills Required
- Drupal entity API and config entities
- PHP property definitions and validation

## Acceptance Criteria
- [ ] Add authentication_mode property to McpToolConfig entity class
- [ ] Implement getAuthenticationMode() and setAuthenticationMode() methods with validation
- [ ] Add isAuthenticationRequired() helper method
- [ ] Add authentication_mode to config_export annotation
- [ ] Update config schema with authentication_mode field and constraints
- [ ] Default value set to "optional" for backward compatibility

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
<details>
<summary>Implementation Details</summary>

**File Locations:**
- Entity: `/var/www/html/web/modules/contrib/mcp_server/src/Entity/McpToolConfig.php:59`
- Schema: `/var/www/html/web/modules/contrib/mcp_server/config/schema/mcp_server.schema.yml:22`

**Entity Property:**
```php
/**
 * The authentication mode for this tool.
 *
 * @var string
 */
protected $authentication_mode = 'optional';
```

**Methods to Add:**
```php
public function getAuthenticationMode(): string {
  return $this->authentication_mode ?? 'optional';
}

public function setAuthenticationMode(string $mode): self {
  if (!in_array($mode, ['required', 'optional', 'disabled'], TRUE)) {
    throw new \InvalidArgumentException('Invalid authentication mode');
  }
  $this->authentication_mode = $mode;
  return $this;
}

public function isAuthenticationRequired(): bool {
  return $this->getAuthenticationMode() === 'required';
}
```

**Schema Updates:**
```yaml
authentication_mode:
  type: string
  label: 'Authentication Mode'
  constraints:
    AllowedValues: [required, optional, disabled]
```

**Config Export:**
Add `authentication_mode` to the `config_export` annotation array in the entity class.
</details>

## Input Dependencies
None - This is the foundation task.

## Output Artifacts
- Updated McpToolConfig entity with authentication_mode support
- Updated configuration schema
- Entity ready for form integration and service usage
