---
id: 2
group: "ui-layer"
dependencies: [1]
status: "completed"
created: "2025-11-09"
completed: "2025-11-09"
skills:
  - drupal-backend
  - forms
---
# Add authentication mode selector to admin form

## Objective
Update McpToolConfigForm to expose the authentication_mode field with clear labels and help text, positioned logically in the form workflow.

## Skills Required
- Drupal Form API
- Entity form integration

## Acceptance Criteria
- [ ] Add authentication_mode select field to McpToolConfigForm
- [ ] Position field between Description and Status fields
- [ ] Include clear option labels explaining each mode
- [ ] Add help text describing security implications
- [ ] Indicate default ("optional") selection visually
- [ ] Form validates and saves authentication_mode correctly

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
<details>
<summary>Implementation Details</summary>

**File Location:**
- Form: `/var/www/html/web/modules/contrib/mcp_server/src/Form/McpToolConfigForm.php:15`

**Form Element:**
```php
$form['authentication_mode'] = [
  '#type' => 'select',
  '#title' => $this->t('Authentication Mode'),
  '#description' => $this->t('Controls whether this tool requires authentication. <strong>Required</strong>: Rejects anonymous requests. <strong>Optional</strong>: Accepts both authenticated and anonymous requests (default). <strong>Disabled</strong>: Skips authentication checks entirely.'),
  '#options' => [
    'required' => $this->t('Required - Authentication mandatory'),
    'optional' => $this->t('Optional - Authentication allowed but not required (default)'),
    'disabled' => $this->t('Disabled - No authentication checks'),
  ],
  '#default_value' => $entity->getAuthenticationMode(),
  '#required' => TRUE,
];
```

**Placement:**
Insert after the 'description' field and before the 'status' field in the form build method.

**Form Submission:**
The entity form should automatically handle the authentication_mode field through copyFormValuesToEntity() if properly defined.
</details>

## Input Dependencies
- Task 1: McpToolConfig entity with getAuthenticationMode() and setAuthenticationMode() methods

## Output Artifacts
- Updated admin form with authentication mode selector
- Functional UI for configuring authentication requirements
