---
id: 3
group: "enforcement"
dependencies: []
status: "completed"
created: "2025-11-09"
skills:
  - php
  - error-handling
---
# Create AuthenticationRequiredException class

## Objective
Implement a custom exception class for authentication failures that can be caught and transformed into proper JSON-RPC error responses.

## Skills Required
- PHP exception handling
- Exception class design

## Acceptance Criteria
- [ ] Create AuthenticationRequiredException extending RuntimeException
- [ ] Constructor accepts tool name and authentication mode
- [ ] Provides getter methods for tool name and mode
- [ ] Includes clear error message in exception
- [ ] Follows Drupal coding standards

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
<details>
<summary>Implementation Details</summary>

**File Location:**
Create new file: `/var/www/html/web/modules/contrib/mcp_server/src/Exception/AuthenticationRequiredException.php`

**Class Implementation:**
```php
<?php

namespace Drupal\mcp_server\Exception;

/**
 * Exception thrown when authentication is required but not provided.
 */
class AuthenticationRequiredException extends \RuntimeException {

  /**
   * The tool name that requires authentication.
   *
   * @var string
   */
  protected $toolName;

  /**
   * The authentication mode configured.
   *
   * @var string
   */
  protected $authenticationMode;

  /**
   * Constructs an AuthenticationRequiredException.
   *
   * @param string $tool_name
   *   The name of the tool requiring authentication.
   * @param string $authentication_mode
   *   The authentication mode (e.g., 'required').
   * @param \Throwable|null $previous
   *   The previous throwable for chaining.
   */
  public function __construct(string $tool_name, string $authentication_mode = 'required', \Throwable $previous = NULL) {
    $this->toolName = $tool_name;
    $this->authenticationMode = $authentication_mode;

    $message = sprintf(
      'Authentication required for tool "%s" (mode: %s)',
      $tool_name,
      $authentication_mode
    );

    parent::__construct($message, 0, $previous);
  }

  /**
   * Gets the tool name.
   *
   * @return string
   *   The tool name.
   */
  public function getToolName(): string {
    return $this->toolName;
  }

  /**
   * Gets the authentication mode.
   *
   * @return string
   *   The authentication mode.
   */
  public function getAuthenticationMode(): string {
    return $this->authenticationMode;
  }

}
```
</details>

## Input Dependencies
None - This is an independent component.

## Output Artifacts
- AuthenticationRequiredException class ready for use in service layer
