---
id: 6
group: "integration"
dependencies: []
status: "completed"
created: "2025-11-09"
skills:
  - drupal-backend
  - routing
---
# Enable OAuth authentication on MCP tool execution route

## Objective
Update the mcp_server.handle route configuration to enable Simple OAuth authentication middleware.

## Skills Required
- Drupal routing configuration
- Simple OAuth integration

## Acceptance Criteria
- [ ] Add _auth: ['oauth2'] to route options
- [ ] Verify route configuration syntax is correct
- [ ] Route allows Bearer token authentication
- [ ] Route maintains backward compatibility (anonymous still allowed)
- [ ] Cache rebuild after route changes

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
<details>
<summary>Implementation Details</summary>

**File Location:**
- Routing: `/var/www/html/web/modules/contrib/mcp_server/mcp_server.routing.yml:1`

**Route Update:**
Find the `mcp_server.handle` route (or equivalent MCP tool execution endpoint) and add:

```yaml
mcp_server.handle:
  path: '/mcp/handle'  # or whatever the current path is
  defaults:
    _controller: '\Drupal\mcp_server\Controller\McpServerController::handle'
  requirements:
    _permission: 'access content'  # or current permission
  options:
    _auth: ['oauth2']  # ADD THIS LINE
```

**Important Notes:**
- The `_auth: ['oauth2']` option enables Simple OAuth middleware
- This allows Bearer tokens but DOES NOT require them
- Anonymous users can still access the route (enforcement happens in service layer)
- Simple OAuth will set user context if valid token provided, otherwise user remains anonymous

**Cache Rebuild:**
After modifying routing.yml, rebuild cache:
```bash
vendor/bin/drush cache:rebuild
```
</details>

## Input Dependencies
None - This is independent routing configuration.

## Output Artifacts
- Updated routing configuration with OAuth support
- Route ready to accept Bearer tokens
- Simple OAuth middleware active on MCP endpoint
