---
id: 7
group: "testing"
dependencies: [1, 4]
status: "completed"
created: "2025-11-09"
completed: "2025-11-09"
skills:
  - phpunit
  - drupal-testing
---
# Write kernel tests for entity and service authentication logic

## Objective
Create comprehensive kernel tests verifying entity configuration, service authentication enforcement, and all three authentication modes.

## Skills Required
- Drupal kernel testing
- PHPUnit test writing
- Mock object creation

## Acceptance Criteria
- [ ] Test McpToolConfig entity getter/setter methods with validation
- [ ] Test default authentication_mode is "optional"
- [ ] Test isAuthenticationRequired() helper method
- [ ] Test McpBridgeService with authenticated user + required mode (pass)
- [ ] Test McpBridgeService with anonymous user + required mode (throw exception)
- [ ] Test McpBridgeService with anonymous user + optional mode (pass)
- [ ] Test McpBridgeService with disabled mode (fast path, no checks)
- [ ] All tests pass, 100% coverage of authentication code paths

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
<details>
<summary>Implementation Details</summary>

**Meaningful Test Strategy Guidelines**

Your critical mantra for test generation is: "write a few tests, mostly integration".

**Definition of "Meaningful Tests":**
Tests that verify custom business logic, critical paths, and edge cases specific to the application. Focus on testing YOUR code, not the framework or library functionality.

**When TO Write Tests:**
- Custom business logic and algorithms
- Critical user workflows and data transformations
- Edge cases and error conditions for core functionality
- Integration points between different system components
- Complex validation logic or calculations

**When NOT to Write Tests:**
- Third-party library functionality (already tested upstream)
- Framework features (React hooks, Express middleware, etc.)
- Simple CRUD operations without custom logic
- Getter/setter methods or basic property access
- Configuration files or static data
- Obvious functionality that would break immediately if incorrect

**Test Focus for This Task:**
- Authentication mode validation logic (custom business logic)
- Service enforcement of authentication requirements (critical path)
- Edge cases: anonymous + required, authenticated + required, disabled mode

**File Location:**
Create: `/var/www/html/web/modules/contrib/mcp_server/tests/src/Kernel/McpAuthenticationTest.php`

**Test Structure:**
```php
<?php

namespace Drupal\Tests\mcp_server\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\mcp_server\Entity\McpToolConfig;
use Drupal\mcp_server\Exception\AuthenticationRequiredException;

/**
 * Tests authentication mode configuration and enforcement.
 *
 * @group mcp_server
 */
class McpAuthenticationTest extends KernelTestBase {

  protected static $modules = ['mcp_server', 'tool', 'simple_oauth', 'user'];

  protected function setUp(): void {
    parent::setUp();
    $this->installEntitySchema('user');
    $this->installEntitySchema('mcp_tool_config');
    $this->installConfig(['mcp_server']);
  }

  /**
   * Test entity authentication mode configuration.
   */
  public function testEntityAuthenticationMode() {
    // Test default value
    // Test setter validation
    // Test getter
    // Test isAuthenticationRequired()
  }

  /**
   * Test service enforcement with required mode.
   */
  public function testServiceRequiredModeEnforcement() {
    // Create tool config with required mode
    // Mock CurrentUser as anonymous
    // Expect AuthenticationRequiredException
  }

  /**
   * Test service allows authenticated users with required mode.
   */
  public function testServiceRequiredModeWithAuthenticatedUser() {
    // Create tool config with required mode
    // Mock CurrentUser as authenticated
    // Expect tool execution succeeds
  }

  /**
   * Test service allows anonymous users with optional mode.
   */
  public function testServiceOptionalModeWithAnonymous() {
    // Create tool config with optional mode
    // Mock CurrentUser as anonymous
    // Expect tool execution succeeds
  }

  /**
   * Test service skips checks with disabled mode.
   */
  public function testServiceDisabledModeSkipsChecks() {
    // Create tool config with disabled mode
    // Mock CurrentUser as anonymous
    // Expect tool execution succeeds (fast path)
  }

}
```

**Running Tests:**
```bash
vendor/bin/phpunit --group mcp_server
```
</details>

## Input Dependencies
- Task 1: McpToolConfig entity with authentication methods
- Task 4: McpBridgeService with authentication enforcement

## Output Artifacts
- Comprehensive kernel tests
- Verified authentication logic correctness
- Coverage for all authentication modes
