---
id: 8
group: "testing"
dependencies: [5, 6]
status: "completed"
created: "2025-11-09"
completed: "2025-11-10"
skills:
  - phpunit
  - drupal-testing
notes: |
  Comprehensive functional tests created. During implementation, discovered and fixed
  critical architectural bug: MCP server was not registering tools. Created McpServerFactory
  to properly integrate Tool API with MCP SDK. Tests validate HTTP authentication flows,
  JSON-RPC error responses, and WWW-Authenticate headers per MCP protocol requirements.
---
# Write functional tests for end-to-end authentication flows

## Objective
Create functional tests that verify complete HTTP request/response flows including OAuth token validation, error responses, and WWW-Authenticate headers.

## Skills Required
- Drupal functional testing
- HTTP testing
- OAuth token creation and validation

## Acceptance Criteria
- [ ] Test anonymous request to required mode tool returns 401 with WWW-Authenticate header
- [ ] Test valid Bearer token to required mode tool succeeds
- [ ] Test invalid/expired Bearer token to required mode tool (user remains anonymous, gets 401)
- [ ] Test anonymous request to optional mode tool succeeds
- [ ] Test JSON-RPC error format matches specification
- [ ] Test error includes tool name and authentication_mode in data field
- [ ] All tests pass

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
<details>
<summary>Implementation Details</summary>

**Meaningful Test Strategy Guidelines**

Your critical mantra for test generation is: "write a few tests, mostly integration".

**Test Focus for This Task:**
- End-to-end authentication flows (integration testing)
- JSON-RPC error response format (custom business logic)
- HTTP header validation (critical path)
- OAuth token integration (integration point)

**File Location:**
Create: `/var/www/html/web/modules/contrib/mcp_server/tests/src/Functional/McpAuthenticationFunctionalTest.php`

**Test Structure:**
```php
<?php

namespace Drupal\Tests\mcp_server\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests authentication flows via HTTP requests.
 *
 * @group mcp_server
 */
class McpAuthenticationFunctionalTest extends BrowserTestBase {

  protected static $modules = ['mcp_server', 'tool', 'simple_oauth', 'user'];

  protected $defaultTheme = 'stark';

  protected function setUp(): void {
    parent::setUp();
    // Create OAuth client
    // Create test tool configs with different modes
  }

  /**
   * Test anonymous request to required mode tool.
   */
  public function testAnonymousRequestToRequiredModeTool() {
    // POST to MCP endpoint without Authorization header
    // Assert 401 status
    // Assert WWW-Authenticate header present
    // Assert JSON-RPC error format
    // Assert error code is -32001
    // Assert error data includes tool name and mode
  }

  /**
   * Test authenticated request to required mode tool.
   */
  public function testAuthenticatedRequestToRequiredModeTool() {
    // Create OAuth access token
    // POST to MCP endpoint with Bearer token
    // Assert 200 status
    // Assert tool execution succeeded
  }

  /**
   * Test invalid token to required mode tool.
   */
  public function testInvalidTokenToRequiredModeTool() {
    // POST to MCP endpoint with invalid Bearer token
    // Assert 401 status (user remains anonymous)
    // Assert JSON-RPC error format
  }

  /**
   * Test anonymous request to optional mode tool.
   */
  public function testAnonymousRequestToOptionalModeTool() {
    // POST to MCP endpoint without Authorization header
    // Assert 200 status
    // Assert tool execution succeeded
  }

}
```

**OAuth Token Creation:**
Use Simple OAuth test utilities or create tokens via:
```php
$token = $this->container->get('simple_oauth.access_token.generator')
  ->generate($user, $client, $scopes);
```

**HTTP Request Pattern:**
```php
$response = $this->drupalPost(
  '/mcp/handle',
  json_encode($jsonrpc_request),
  [
    'Content-Type' => 'application/json',
    'Authorization' => 'Bearer ' . $token,
  ]
);
```

**Running Tests:**
```bash
vendor/bin/phpunit --group mcp_server --testsuite=functional
```
</details>

## Input Dependencies
- Task 5: Controller with authentication error handling
- Task 6: Route with OAuth authentication enabled

## Output Artifacts
- Functional tests for HTTP authentication flows
- Verified OAuth integration
- Verified JSON-RPC error responses
- Verified WWW-Authenticate headers
