---
id: 1
group: "oauth-infrastructure"
dependencies: []
status: "completed"
created: "2025-11-10"
skills:
  - composer
  - drupal-backend
---
# Install Simple OAuth Module and Dependencies

## Objective
Install Simple OAuth module (^6.0) and e0ipso/simple_oauth_21 package to provide oauth2_token and oauth2_scope entity infrastructure required for scope management.

## Skills Required
- **composer**: Manage PHP dependencies and install modules
- **drupal-backend**: Enable and verify Drupal modules

## Acceptance Criteria
- [x] Simple OAuth module (^6.0) added to composer.json and installed
- [x] e0ipso/simple_oauth_21 (^1.0) package added and installed
- [x] simple_oauth module enabled via Drush
- [x] oauth2_token, oauth2_scope, and oauth2_client entities verified to exist
- [x] Database updates run successfully

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
- Add to composer.json require section:
  - `"drupal/simple_oauth": "^6.0"`
  - `"e0ipso/simple_oauth_21": "^1.0"`
- Run composer require commands
- Enable module with `vendor/bin/drush pm:enable simple_oauth`
- Run database updates with `vendor/bin/drush updatedb`
- Verify entities with `vendor/bin/drush entity:list | grep oauth2`

## Input Dependencies
None - this is a foundational task

## Output Artifacts
- Simple OAuth module installed and enabled
- oauth2_token content entity available
- oauth2_scope config entity available
- oauth2_client config entity available
- Entity storage services available for dependency injection

## Implementation Notes
<details>
<summary>Detailed Implementation Steps</summary>

1. **Update composer.json**:
   - Add both dependencies to the require section
   - Run `composer require drupal/simple_oauth:^6.0`
   - Run `composer require e0ipso/simple_oauth_21:^1`

2. **Enable module**:
   ```bash
   vendor/bin/drush pm:enable simple_oauth -y
   vendor/bin/drush updatedb -y
   ```

3. **Verification commands**:
   ```bash
   # Check entity types exist
   vendor/bin/drush entity:list | grep oauth2

   # Should show:
   # - oauth2_token (content entity)
   # - oauth2_scope (config entity)
   # - oauth2_client (config entity)
   ```

4. **Verify storage available**:
   - EntityTypeManager should be able to load storage for 'oauth2_token', 'oauth2_scope', and 'oauth2_client'
   - Check that oauth2_token entity has scopes field with getScopes() method

5. **Error handling**:
   - If composer fails, check for version conflicts
   - If drush enable fails, check module dependencies
   - If entity verification fails, check database updates ran successfully
</details>
