---
id: 2
group: "entity-configuration"
dependencies: [1]
status: "completed"
created: "2025-11-10"
skills:
  - drupal-backend
  - php
---
# Add Scopes Field to McpToolConfig Entity

## Objective
Extend McpToolConfig entity with a scopes field to store required OAuth scope IDs, including property definition, getter/setter methods, config export, and configuration schema.

## Skills Required
- **drupal-backend**: Drupal entity development and configuration entity patterns
- **php**: PHP class modification and type-safe method implementation

## Acceptance Criteria
- [x] $scopes property added to McpToolConfig entity with array type
- [x] getScopes() method returns array of scope IDs
- [x] setScopes() method accepts array and returns static
- [x] scopes added to config_export array in entity annotation
- [x] Configuration schema updated in mcp_server.schema.yml
- [x] Default empty array behavior documented
- [x] Config export/import works correctly with scopes field

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
- File: `src/Entity/McpToolConfig.php`
- File: `config/schema/mcp_server.schema.yml`
- Property type: `protected array $scopes = [];`
- Methods: `getScopes(): array` and `setScopes(array $scopes): static`
- Schema type: sequence of strings

## Input Dependencies
- Simple OAuth module installed (Task 1)
- McpToolConfig entity exists from PRD 1

## Output Artifacts
- McpToolConfig entity with scopes property and methods
- Configuration schema for scopes field
- Ability to persist scope IDs in config
- Foundation for scope validation logic

## Implementation Notes
<details>
<summary>Detailed Implementation Steps</summary>

1. **Add property to McpToolConfig.php**:
   ```php
   /**
    * Array of required OAuth scope IDs.
    *
    * @var array
    */
   protected array $scopes = [];
   ```

2. **Add getter method**:
   ```php
   /**
    * Gets the required OAuth scopes for this tool.
    *
    * @return array
    *   Array of scope IDs (strings).
    */
   public function getScopes(): array {
     return $this->scopes;
   }
   ```

3. **Add setter method**:
   ```php
   /**
    * Sets the required OAuth scopes for this tool.
    *
    * @param array $scopes
    *   Array of scope IDs.
    *
    * @return $this
    */
   public function setScopes(array $scopes): static {
     $this->scopes = $scopes;
     return $this;
   }
   ```

4. **Update config_export in entity annotation**:
   Add "scopes" to the existing config_export array

5. **Add schema definition to config/schema/mcp_server.schema.yml**:
   ```yaml
   scopes:
     type: sequence
     label: 'Required OAuth Scopes'
     description: 'OAuth scopes required to execute this tool'
     sequence:
       type: string
       label: 'Scope ID'
   ```

6. **Behavior notes**:
   - Empty array = no scope restrictions (any authenticated user)
   - Ignored when authentication_mode is 'disabled'
   - Validated when authentication_mode is 'required' or 'optional'

7. **Testing**:
   - Load entity, call getScopes(), should return empty array by default
   - Call setScopes(['scope1', 'scope2']), save, reload, verify persistence
   - Export config with drush cex, verify scopes field appears correctly
</details>
