---
id: 3
group: "scope-validation"
dependencies: [1]
status: "completed"
created: "2025-11-10"
skills:
  - drupal-backend
  - php
---
# Create OAuthScopeValidator Service

## Objective
Implement OAuthScopeValidator service to extract OAuth scopes from access tokens and validate them against tool requirements, including ScopeValidationResult value object and service definition.

## Skills Required
- **drupal-backend**: Drupal service development, dependency injection, and entity loading
- **php**: PHP 8.3 features (readonly classes, named parameters, constructor property promotion)

## Acceptance Criteria
- [x] OAuthScopeValidator class created with extractTokenScopes() method
- [x] Token extraction from Authorization header works correctly
- [x] oauth2_token entity loading by value implemented
- [x] Token revocation and expiration checks functional
- [x] Scope extraction using Simple OAuth's getScopes() API
- [x] validateScopes() method with AND logic for required scopes
- [x] ScopeValidationResult value object with isValid, missingScopes, requiredScopes, tokenScopes
- [x] Service registered in mcp_server.services.yml
- [x] Defensive programming returns empty array on failures

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
- File: `src/Service/OAuthScopeValidator.php`
- File: `src/Service/ScopeValidationResult.php`
- File: `mcp_server.services.yml`
- Dependencies: EntityTypeManagerInterface, RequestStack
- Return type for extractTokenScopes: `array`
- Return type for validateScopes: `ScopeValidationResult`

## Input Dependencies
- Simple OAuth module installed (Task 1)
- oauth2_token entity available
- Authorization header with Bearer token

## Output Artifacts
- OAuthScopeValidator service available for injection
- Token scope extraction capability
- Scope validation with detailed results
- Foundation for McpBridgeService integration

## Implementation Notes
<details>
<summary>Detailed Implementation Steps</summary>

1. **Create OAuthScopeValidator.php**:
   Follow the implementation from the plan's Component 5:
   - Constructor with EntityTypeManagerInterface and RequestStack
   - extractTokenScopes() method:
     - Get Authorization header from request
     - Extract Bearer token value
     - Load oauth2_token by value
     - Check isRevoked() and expire field
     - Extract scopes using getScopes() method
     - Return empty array on any failure
   - validateScopes(array $required, array $token) method:
     - Use array_diff to find missing scopes
     - Return ScopeValidationResult with validation status

2. **Create ScopeValidationResult.php**:
   ```php
   final readonly class ScopeValidationResult {
     public function __construct(
       public bool $isValid,
       public array $missingScopes,
       public array $requiredScopes,
       public array $tokenScopes,
     ) {}
   }
   ```

3. **Register service in mcp_server.services.yml**:
   ```yaml
   mcp_server.oauth_scope_validator:
     class: Drupal\mcp_server\Service\OAuthScopeValidator
     arguments:
       - '@entity_type.manager'
       - '@request_stack'
   ```

4. **Implementation patterns from jsonrpc_mcp**:
   - Load token: `loadByProperties(['value' => $token_value])`
   - Check revocation: `$token->isRevoked()`
   - Check expiry: `$token->get('expire')->value < time()`
   - Extract scopes: `$token->get('scopes')->getScopes()`

5. **Error handling strategy**:
   - No request → return []
   - No Authorization header → return []
   - Token not found → return []
   - Token revoked/expired → return []
   - Any exception → return []

6. **Validation logic**:
   - AND logic: ALL required scopes must be in token scopes
   - Missing = array_diff(required, token)
   - Valid = empty(missing)
</details>
