---
id: 4
group: "scope-validation"
dependencies: []
status: "completed"
created: "2025-11-10"
skills:
  - php
---
# Create InsufficientScopeException Class

## Objective
Implement InsufficientScopeException class for OAuth scope validation errors with detailed scope information for error responses.

## Skills Required
- **php**: PHP exception class development with custom properties and methods

## Acceptance Criteria
- [x] InsufficientScopeException class extends RuntimeException
- [x] Constructor accepts toolName, requiredScopes, missingScopes, currentScopes
- [x] Getter methods for all custom properties
- [x] getErrorData() method returns array for JSON-RPC error response
- [x] Exception provides all data needed for 403 error formatting

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
- File: `src/Exception/InsufficientScopeException.php`
- Namespace: `Drupal\mcp_server\Exception`
- Extends: `\RuntimeException`
- Properties: toolName, requiredScopes, missingScopes, currentScopes (all readonly)

## Input Dependencies
None - this is a standalone exception class

## Output Artifacts
- InsufficientScopeException class for scope validation failures
- Structured error data for JSON-RPC responses
- Foundation for controller error handling

## Implementation Notes
<details>
<summary>Detailed Implementation Steps</summary>

1. **Create InsufficientScopeException.php**:
   Follow the implementation from the plan's Component 7:
   ```php
   class InsufficientScopeException extends \RuntimeException {
     public function __construct(
       string $message,
       private readonly string $toolName,
       private readonly array $requiredScopes,
       private readonly array $missingScopes,
       private readonly array $currentScopes,
       int $code = 0,
       ?\Throwable $previous = NULL,
     ) {
       parent::__construct($message, $code, $previous);
     }

     public function getToolName(): string { ... }
     public function getRequiredScopes(): array { ... }
     public function getMissingScopes(): array { ... }
     public function getCurrentScopes(): array { ... }
     public function getErrorData(): array { ... }
   }
   ```

2. **getErrorData() implementation**:
   ```php
   public function getErrorData(): array {
     return [
       'tool' => $this->toolName,
       'required_scopes' => $this->requiredScopes,
       'missing_scopes' => $this->missingScopes,
       'current_scopes' => $this->currentScopes,
     ];
   }
   ```

3. **Usage pattern**:
   ```php
   throw new InsufficientScopeException(
     "Insufficient OAuth scopes for tool 'widget.create'",
     'widget.create',
     ['widget:write', 'widget:create'],
     ['widget:create'],
     ['widget:write']
   );
   ```

4. **Expected JSON-RPC error response structure**:
   ```json
   {
     "jsonrpc": "2.0",
     "error": {
       "code": -32003,
       "message": "Insufficient OAuth scopes",
       "data": {
         "tool": "widget.create",
         "required_scopes": ["widget:write", "widget:create"],
         "missing_scopes": ["widget:create"],
         "current_scopes": ["widget:write"]
       }
     },
     "id": null
   }
   ```

5. **HTTP response requirements**:
   - Status: 403 Forbidden
   - Header: WWW-Authenticate: `Bearer error="insufficient_scope"`
</details>
