---
id: 8
group: "testing"
dependencies: [6, 7]
status: "completed"
created: "2025-11-10"
completed: "2025-11-10"
skills:
  - phpunit
  - drupal-backend
---
# Write Comprehensive Tests for OAuth Scope Management

## Objective
Create unit, kernel, and functional tests to verify OAuth scope validation, entity persistence, and end-to-end scope enforcement across all authentication modes.

## Skills Required
- **phpunit**: Writing unit, kernel, and functional tests
- **drupal-backend**: Drupal testing patterns, mock objects, and test fixtures

## Acceptance Criteria
- [ ] Unit tests for OAuthScopeValidator::validateScopes() logic
- [ ] Kernel tests for token loading and scope extraction
- [ ] Kernel tests for McpToolConfig scope field persistence
- [ ] Functional tests for scope enforcement in required mode
- [ ] Functional tests for scope warnings in optional mode
- [ ] Functional tests for disabled mode (no scope checks)
- [ ] Functional tests for form scope selection UI
- [ ] Test coverage for error responses with scope details
- [ ] All tests passing with vendor/bin/phpunit

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
- Test directory: `tests/src/Unit/`, `tests/src/Kernel/`, `tests/src/Functional/`
- Test naming: `*Test.php`
- PHPUnit attributes for test organization
- Mock oauth2_token and oauth2_scope entities
- Test authenticated and anonymous users

## Input Dependencies
- Complete scope validation implementation (Task 6)
- Complete error handling (Task 7)
- Functional McpBridgeService with scope checks

## Output Artifacts
- Comprehensive test suite for scope management
- Verification of all authentication modes
- Coverage of edge cases and error conditions
- Regression prevention for future changes

## Implementation Notes

**IMPORTANT**: Copy and keep in mind the _Meaningful Test Strategy Guidelines_ from the plan generation command.

<details>
<summary>Detailed Implementation Steps</summary>

1. **Unit Tests (OAuthScopeValidatorTest.php)**:
   - Test validateScopes() with various combinations:
     - All scopes present → isValid = true
     - Some scopes missing → isValid = false, correct missing scopes
     - No required scopes → isValid = true
     - Empty token scopes → isValid = false (if required scopes exist)

2. **Kernel Tests (OAuthScopeValidatorKernelTest.php)**:
   - Create mock oauth2_token entity
   - Test extractTokenScopes() with:
     - Valid token → returns scope array
     - Revoked token → returns []
     - Expired token → returns []
     - Missing token → returns []
     - No Authorization header → returns []

3. **Kernel Tests (McpToolConfigEntityTest.php)**:
   - Create McpToolConfig entity
   - Test setScopes() / getScopes()
   - Save and reload entity
   - Verify scopes persist correctly
   - Test config export includes scopes

4. **Functional Tests (ScopeEnforcementTest.php)**:
   - Test required mode:
     - Anonymous user → 401
     - Authenticated with all scopes → success
     - Authenticated with missing scopes → 403 with scope details
   - Test optional mode:
     - Anonymous user → success
     - Authenticated with scopes → success
     - Authenticated without scopes → success (with warning logged)
   - Test disabled mode:
     - Anonymous user → success
     - No scope checks performed

5. **Functional Tests (McpToolConfigFormTest.php)**:
   - Load form at /admin/config/services/mcp-server/[tool]/edit
   - Verify scopes field present
   - Test conditional display (visible for required/optional, hidden for disabled)
   - Select scopes, submit, verify saved correctly
   - Test with no oauth2_scope entities (graceful degradation)

6. **Test fixtures needed**:
   - Mock oauth2_scope entities with test IDs
   - Mock oauth2_token entities with scopes field
   - Mock McpToolConfig entities with various authentication modes
   - Test Bearer tokens for Authorization header

7. **Edge cases to test**:
   - Empty scopes array in config (no restrictions)
   - Empty scopes in token (should fail if tool requires any)
   - Case sensitivity in scope matching (should be exact match)
   - Array order independence (scopes can be in any order)
   - Duplicate scopes (should be handled gracefully)

8. **Error response verification**:
   - 403 response contains error.code = -32003
   - error.data contains tool, required_scopes, missing_scopes, current_scopes
   - WWW-Authenticate header present
   - request_id preserved in response

9. **Focus on meaningful tests**:
   - Test business logic (scope AND validation, empty array behavior)
   - Test integration points (entity loading, service injection)
   - Test critical paths (required mode enforcement)
   - SKIP testing Form API functionality (framework already tested)
   - SKIP testing Simple OAuth's getScopes() method (library already tested)
</details>
