---
id: 1
group: "test-elimination"
dependencies: []
status: "completed"
created: 2025-11-10
completed: 2025-11-10
skills:
  - phpunit
---
# Eliminate Redundant Unit and Framework Tests

## Objective
Remove unit tests testing PHP language features and kernel tests testing Drupal framework CRUD operations, reducing test count while maintaining business logic coverage.

## Skills Required
- **phpunit**: Understanding PHPUnit test structure and execution to identify and safely remove tests

## Acceptance Criteria
- [ ] Delete `tests/src/Unit/OAuthScopeValidatorTest.php` entirely
- [ ] Remove entity CRUD tests from `McpToolConfigTest`: `testEntityCrudOperations()`, `testConfigurationExportImport()`
- [ ] Remove entity persistence tests from `OAuthScopeIntegrationTest`: `testScopeFieldPersistence()`, `testEmptyScopesPersistence()`
- [ ] Remove cache tests from `OAuthScopeDiscoveryServiceTest`: `testCacheInvalidation()`, `testCacheInvalidationOnDelete()`
- [ ] Remove `testGetAvailableToolApiTools()` from `McpBridgeServiceTest`
- [ ] Run test suite and verify zero new failures
- [ ] Verify custom validation tests remain: `testToolIdRequired()`, `testMcpNameFallback()`, `testAuthenticationModeValidation()`

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
- PHPUnit 9.x test framework
- Drupal 11 testing infrastructure
- Understanding of what constitutes framework vs. business logic testing

## Input Dependencies
None - this is the first cleanup phase

## Output Artifacts
- Reduced test suite with framework tests removed
- All remaining tests passing

## Implementation Notes

<details>
<summary>Detailed Implementation Instructions</summary>

**Phase 1: Delete Unit Test File**
```bash
rm tests/src/Unit/OAuthScopeValidatorTest.php
```

**Phase 2: Edit McpToolConfigTest**
Remove these two complete test methods:
- `testEntityCrudOperations()` - Tests save/load/update/delete (Drupal core functionality)
- `testConfigurationExportImport()` - Tests `toArray()` (ConfigEntityBase functionality)

Keep these methods (they test module-specific logic):
- `testMcpNameFallback()` - Custom getter logic
- `testToolIdRequired()` - Custom validation

**Phase 3: Edit OAuthScopeIntegrationTest**
Remove these test methods:
- `testScopeFieldPersistence()` - Tests entity save/load
- `testEmptyScopesPersistence()` - Tests entity save/load

Keep all authentication mode enforcement tests (they test business logic).

**Phase 4: Edit OAuthScopeDiscoveryServiceTest**
Remove these test methods:
- `testCacheInvalidation()` - Tests Drupal cache tag system
- `testCacheInvalidationOnDelete()` - Tests Drupal entity cache tags

Keep scope aggregation and discovery tests (they test business logic).

**Phase 5: Edit McpBridgeServiceTest**
Remove this test method:
- `testGetAvailableToolApiTools()` - Pass-through wrapper with no logic

**Phase 6: Verify**
```bash
cd /var/www/html
vendor/bin/phpunit web/modules/contrib/mcp_server/tests/
```

All tests should pass. The test count should decrease but no new failures should appear.

**Testing Philosophy Reminder:**
Do NOT test framework behavior:
- Entity CRUD (save/load/delete) is tested by Drupal core
- Cache invalidation is tested by Drupal core
- PHP array operations are tested by PHP itself

DO test module-specific logic:
- Custom validation rules
- Custom computed values
- Business workflow integration
</details>
