---
id: 2
group: "test-consolidation"
dependencies: [1]
status: "completed"
created: 2025-11-10
completed: 2025-11-10
skills:
  - phpunit
  - drupal-backend
---
# Consolidate Duplicate Kernel Tests

## Objective
Merge duplicate authentication and integration tests, eliminate redundant test files, and consolidate validation logic into appropriate test classes.

## Skills Required
- **phpunit**: Test refactoring and consolidation techniques
- **drupal-backend**: Understanding Drupal kernel test architecture and service testing

## Acceptance Criteria
- [x] Delete `tests/src/Kernel/ToolApiMcpIntegrationTest.php` entirely (redundant with McpBridgeServiceTest)
- [x] Delete `tests/src/Kernel/McpAuthenticationTest.php` entirely (redundant with OAuthScopeIntegrationTest)
- [x] Move `testAuthenticationModeValidation()` from McpAuthenticationTest to McpToolConfigTest before deletion
- [x] Remove wrapper tests from `ToolApiDiscoveryTest`: `testGetAvailableTools()`, `testExecuteToolMinimalParameters()`
- [x] Keep schema conversion tests in ToolApiDiscoveryTest (unique business logic)
- [x] Run test suite and verify zero new failures

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
- Drupal KernelTestBase understanding
- Service integration testing patterns
- Test method extraction and migration

## Input Dependencies
- Task 1 completed (framework tests removed)
- Clean test suite baseline

## Output Artifacts
- Consolidated kernel test suite
- Fewer test files with no redundancy
- All tests passing

## Implementation Notes

<details>
<summary>Detailed Implementation Instructions</summary>

**Phase 1: Move Validation Test**
Before deleting McpAuthenticationTest, extract the validation test:

1. Open `tests/src/Kernel/McpAuthenticationTest.php`
2. Copy the `testAuthenticationModeValidation()` method
3. Open `tests/src/Kernel/McpToolConfigTest.php`
4. Add the method to McpToolConfigTest (it's testing entity setter validation, which belongs with entity tests)

**Phase 2: Delete Redundant Test Files**
```bash
rm tests/src/Kernel/ToolApiMcpIntegrationTest.php
rm tests/src/Kernel/McpAuthenticationTest.php
```

**Rationale:**
- `ToolApiMcpIntegrationTest` duplicates the complete workflow testing in `McpBridgeServiceTest`
- `McpAuthenticationTest` tests the same authentication scenarios as `OAuthScopeIntegrationTest`
- Authentication mode enforcement is better tested in the OAuth scope integration context

**Phase 3: Slim Down ToolApiDiscoveryTest**
Edit `tests/src/Kernel/ToolApiDiscoveryTest.php` and remove:
- `testGetAvailableTools()` - Wrapper around plugin manager
- `testExecuteToolMinimalParameters()` - Redundant with `testExecuteToolSuccess()`

Keep:
- `testGetToolDefinition()` - Schema conversion logic (business logic)
- `testExecuteToolSuccess()` - Tool execution integration
- `testGetToolDefinitionInvalidId()` - Error handling
- `testExecuteToolInvalidId()` - Error handling

**Phase 4: Verify Consolidation**
```bash
cd /var/www/html
vendor/bin/phpunit web/modules/contrib/mcp_server/tests/
```

Expected results:
- Fewer test files
- Lower test count
- All tests still passing
- No duplicated test scenarios

**Consolidation Rationale:**
- `McpBridgeServiceTest` provides comprehensive end-to-end workflow coverage
- `OAuthScopeIntegrationTest` provides complete authentication mode coverage
- `ToolApiDiscoveryTest` should focus only on schema conversion logic
</details>
