---
id: 5
group: "documentation"
dependencies: [2, 4]
status: "completed"
created: 2025-11-13
skills:
  - technical-writing
---
# Update Documentation for Simplified Architecture

## Objective
Update README.md to accurately reflect the binary authentication system (required/disabled only) and the functional configuration system, removing all references to deprecated "optional" mode.

## Skills Required
- **Technical Writing**: Clear, accurate documentation of system behavior and configuration options

## Acceptance Criteria
- [ ] All references to "optional" authentication mode removed from README.md
- [ ] Authentication section clearly documents required vs disabled modes
- [ ] Configuration section confirms all four settings are functional
- [ ] Examples updated to reflect binary authentication
- [ ] Session TTL status documented (implemented or future enhancement)

Use your internal Todo tool to track these and keep on track.

## Technical Requirements

**File to Modify:**
1. `README.md` - Multiple sections need updates

**Documentation Areas:**
- Authentication configuration and behavior
- Configuration system usage
- Examples in code snippets
- Security considerations

## Input Dependencies
- Task 02 completed: Authentication tests updated
- Task 04 completed: Configuration tests added (confirms functionality)

## Output Artifacts
- Accurate README.md reflecting simplified architecture
- Clear authentication mode documentation
- Verified configuration system documentation

## Implementation Notes

<details>
<summary>Detailed Implementation Steps</summary>

### Step 1: Search for "Optional" References

```bash
cd /var/www/html/web/modules/contrib/mcp_server
grep -n "optional" README.md
```

Find all instances and plan updates.

### Step 2: Update Authentication Mode Section

Locate the section describing authentication modes (if it exists). If not, add clear documentation.

**Add or update authentication section:**

```markdown
### Authentication Modes

MCP tool configurations support two authentication modes:

**Required Authentication** (`required`)
- OAuth2 Bearer token must be present in the request
- Token must include all scopes specified in the tool configuration
- Requests without valid authentication will receive HTTP 401
- Requests with insufficient scopes will receive HTTP 403

**No Authentication** (`disabled`)
- No authentication or authorization checks are performed
- Tool executes for all requests (authenticated or anonymous)
- Use only for tools that require no access control

**Choosing a Mode:**
- Use `required` for tools that modify data or access sensitive information
- Use `disabled` for public tools that provide read-only, non-sensitive information
- When in doubt, prefer `required` for better security

**Example Configuration:**

```yaml
# config/sync/mcp_server.mcp_tool_config.send_email.yml
id: send_email
label: 'Send Email Tool'
tool_id: 'my_module:send_email'
authentication_mode: required  # OAuth required
scopes:
  - 'email:send'
status: true
```
```

### Step 3: Update Configuration Section

Locate the Configuration section (around lines 268-298).

**Verify this section is accurate:**

```markdown
## Configuration

Configuration can be managed at:

```
admin/config/services/mcp-server
```

Or via configuration management. The following settings are available:

**Server Information:**
- `server_name`: The name of the MCP server shown to AI assistants
- `server_version`: Version string for the MCP server

**Operational Settings:**
- `pagination_limit`: Maximum number of items in paginated responses (1-1000, default: 50)
- `session_ttl`: Session time-to-live in seconds (default: 3600)

**Configuration File:**

Edit `config/sync/mcp_server.settings.yml`:

```yaml
server_name: 'Drupal MCP Server'
server_version: '1.0.0'
pagination_limit: 50
session_ttl: 3600  # 1 hour
```

**Applying Configuration Changes:**

```bash
drush config:import
drush cache:rebuild
```

**Validation:**
- `pagination_limit` must be between 1 and 1000. Invalid values will be rejected and defaults used.
- `session_ttl` must be a positive integer
- `server_name` and `server_version` should be non-empty strings
```

**If session_ttl is NOT implemented (from task 03):**

Add a note:
```markdown
> **Note:** `session_ttl` configuration is defined but not yet functional due to upstream SDK limitations. Session TTL is currently hardcoded. This will be implemented when the MCP SDK adds TTL support.
```

### Step 4: Update Security Considerations

Locate the Security Considerations section.

**Update authentication references:**

```markdown
## Security Considerations

- **Authentication Modes**: Tools support two modes: `required` (enforce OAuth) or `disabled` (no auth)
- **Scope-Based Authorization**: Use fine-grained OAuth scopes to control tool access
- **Required vs Disabled**: Prefer `required` mode for any tool that modifies data or accesses sensitive information
- The HTTP endpoint (`/_mcp`) requires the "access content" permission by default
- **IMPORTANT**: For production deployments, create a custom permission to restrict MCP server access
- Implement additional authentication mechanisms (API keys, OAuth, etc.) for production use
- Review and audit which MCP capabilities are exposed to AI assistants
- Session data is stored in the kernel cache directory (configurable)
- All MCP requests are logged via Drupal's logger service
- Consider using HTTPS for all HTTP transport communications
- Validate and sanitize all data in custom MCP tools and resources
```

### Step 5: Search for Example Code with "Optional"

```bash
cd /var/www/html/web/modules/contrib/mcp_server
grep -A 5 -B 5 "authentication_mode" README.md
```

Update any code examples that show `authentication_mode: optional`.

Change to either:
```yaml
authentication_mode: required  # For tools needing OAuth
# OR
authentication_mode: disabled  # For public tools
```

### Step 6: Review Tool API Integration Section

Ensure the Tool API Integration section (lines 143-267) doesn't have outdated authentication references.

### Step 7: Verify Configuration Example

Check the Configuration section example (lines 167-178):

```yaml
# config/sync/mcp_server.mcp_tool_config.example.yml
langcode: en
status: true
id: example
label: 'Example Tool'
tool_id: 'module_name:tool_name'
mcp_name: 'custom_name'
description: 'Custom description for AI context'
authentication_mode: required  # Ensure it's either 'required' or 'disabled'
scopes:
  - 'example:scope'
```

### Step 8: Check for Completeness

Review the entire README.md to ensure:
- [ ] No references to "optional" authentication mode remain
- [ ] All authentication examples use "required" or "disabled"
- [ ] Configuration section accurately describes functional settings
- [ ] Security section reflects binary authentication model
- [ ] Code examples are accurate and runnable

### Step 9: Validate Markdown

Check for markdown formatting issues:
```bash
cd /var/www/html/web/modules/contrib/mcp_server
# If markdown linter available:
npx markdownlint README.md

# Otherwise, just review manually for:
# - Broken links
# - Incorrect code fence languages
# - Malformed headers
# - Inconsistent list formatting
```

</details>
