---
id: 1
group: "configuration-entity"
dependencies: []
status: "completed"
created: 2025-11-16
completed: 2025-11-16
skills:
  - drupal-backend
  - php
status: "completed"
---
# Create McpPromptConfig Configuration Entity

## Objective
Create the McpPromptConfig configuration entity that stores all MCP prompt metadata including name, title, description, arguments, and messages with support for all content types (text, images, audio, resources).

## Skills Required
- drupal-backend: Configuration entity development, entity annotations, cache invalidation
- php: Strict types, validation logic, type hints

## Acceptance Criteria
- [ ] McpPromptConfig entity class exists in src/Entity/McpPromptConfig.php
- [ ] Entity extends ConfigEntityBase with proper annotations
- [ ] Entity keys defined: id (machine name), label (prompt name), status
- [ ] Metadata fields: title (optional), description (optional)
- [ ] Arguments field: array of argument definitions (name, description, required)
- [ ] Messages field: array with role and typed content (text/image/audio/resource)
- [ ] preSave() validation ensures required fields and valid message roles
- [ ] postSave() and postDelete() invalidate 'mcp_server:discovery' cache tag
- [ ] All code uses declare(strict_types=1) and proper type hints
- [ ] Class marked as final

## Technical Requirements
- Follow McpToolConfig pattern from src/Entity/McpToolConfig.php
- PHP 8.3+ with strict types enabled
- Entity annotation with handlers: storage, list_builder, forms
- Config prefix: mcp_prompt_config
- Admin permission: administer mcp prompt configurations
- Routes structure matching tools pattern
- Validation for:
  - Message roles (user/assistant only)
  - Content type structure per MCP spec
  - Base64 validation for images/audio
  - Resource URI format for embedded resources

## Input Dependencies
None - foundational task

## Output Artifacts
- src/Entity/McpPromptConfig.php
- Entity provides getters for all fields
- Cache invalidation hooks integrated

## Implementation Notes
Messages content structure by type:
- Text: {type: 'text', text: 'content'}
- Image: {type: 'image', data: 'base64...', mimeType: 'image/png'}
- Audio: {type: 'audio', data: 'base64...', mimeType: 'audio/wav'}
- Resource: {type: 'resource', resource: {uri: '...', mimeType: '...', text: '...'}}

Keep validation focused on structure, not framework features. Test the validation logic, not Drupal's config entity system.
