---
id: 2
group: "configuration-schema"
dependencies: [1]
status: "completed"
created: 2025-11-16
skills:
  - drupal-backend
---
# Define Configuration Schema for McpPromptConfig

## Objective
Create comprehensive configuration schema for the McpPromptConfig entity to enable proper validation, exports, and site configuration management.

## Skills Required
- drupal-backend: Configuration schema definitions, typed data, sequence/mapping structures

## Acceptance Criteria
- [ ] Schema defined in config/schema/mcp_server.schema.yml
- [ ] mcp_server.mcp_prompt_config.* entry with all entity properties
- [ ] Arguments field defined as sequence of mappings (name, description, required)
- [ ] Messages field defined as sequence of mappings (role, content)
- [ ] Content polymorphic structure supports all types (text, image, audio, resource)
- [ ] Schema validates correctly with Drupal's config validation
- [ ] Exported configs are properly typed

## Technical Requirements
- Schema must match entity structure from task 001
- Use sequence type for arrays
- Use mapping type for nested objects
- Define proper types: string, text, boolean, mapping
- Follow Drupal schema conventions

## Input Dependencies
- Task 001: McpPromptConfig entity structure

## Output Artifacts
- config/schema/mcp_server.schema.yml (updated or created)
- Schema enables config export/import validation

## Implementation Notes
The schema ensures configuration exports are properly validated and typed data works correctly. Reference existing tool config schema if present in the module.

Polymorphic content types need careful schema design to support all variants while maintaining validation.
