---
id: 3
group: "admin-ui"
dependencies: [1]
status: "completed"
created: 2025-11-16
skills:
  - drupal-backend
  - php
---
# Build Complete Admin UI for Prompt Management

## Objective
Create full CRUD administrative interface for managing prompts including list builder, add/edit forms with AJAX support for dynamic arguments and messages, and all necessary routes.

## Skills Required
- drupal-backend: Form API, AJAX callbacks, EntityForm, ListBuilder, routing
- php: Strict types, constructor property promotion, service injection

## Acceptance Criteria
- [ ] McpPromptConfigListBuilder exists showing Name, Title, Description, Status, Operations
- [ ] McpPromptConfigForm handles add/edit with all fields
- [ ] Machine name auto-generated from label
- [ ] Arguments fieldset with AJAX "Add argument" and "Remove" buttons
- [ ] Messages fieldset with AJAX "Add message" and "Remove" buttons
- [ ] Dynamic content fields based on selected content type
- [ ] File upload converts to base64 for images/audio
- [ ] Routes defined in mcp_server.routing.yml for collection, add, edit, delete
- [ ] Menu link added to Configuration > Web Services > MCP Server
- [ ] Form validation for required fields and content type structure
- [ ] Success messages on save/delete operations
- [ ] All code uses declare(strict_types=1) and final classes

## Technical Requirements
- Follow McpToolConfigForm pattern from src/Form/McpToolConfigForm.php
- List builder at /admin/config/services/mcp-server/prompts
- Form routes: /prompts/add, /prompts/{mcp_prompt_config}/edit, /prompts/{mcp_prompt_config}/delete
- AJAX callbacks for add/remove operations
- Form state management for dynamic fields
- Constructor injection for required services
- Delete form uses Drupal's EntityDeleteForm

## Input Dependencies
- Task 001: McpPromptConfig entity for form handler

## Output Artifacts
- src/McpPromptConfigListBuilder.php
- src/Form/McpPromptConfigForm.php
- mcp_server.routing.yml (updated)
- mcp_server.links.menu.yml (updated)
- mcp_server.links.action.yml (updated for "Add prompt" link)

## Implementation Notes
AJAX pattern for arguments:
- Store in form_state['values']['arguments'] as indexed array
- Each add button increments counter
- Remove button rebuilds form without that index
- Use #ajax with callback returning the fieldset

Messages need more complex AJAX:
- Role select (user/assistant)
- Content type select triggers conditional fields
- Text: textarea
- Image/Audio: managed_file element with base64 conversion on submit
- Resource: text fields for uri, mimeType, text

Keep form simple - don't over-engineer the UI. Site builders need clear, functional interface.
