---
id: 4
group: "services-integration"
dependencies: [1]
status: "completed"
created: 2025-11-16
skills:
  - drupal-backend
  - php
---
# Implement Permissions and Discovery Service

## Objective
Add permission-based access control and discovery service for listing and retrieving enabled prompts with proper MCP protocol format transformation.

## Skills Required
- drupal-backend: Permissions system, service definition, dependency injection, caching
- php: Service implementation, type hints, strict types

## Acceptance Criteria
- [ ] 'access mcp server prompts' permission added to mcp_server.permissions.yml
- [ ] 'administer mcp prompt configurations' permission added
- [ ] Discovery service method getEnabledPrompts() returns enabled prompts
- [ ] Discovery service method getMcpPrompt(string $name) retrieves specific prompt
- [ ] Service loads from entity storage and filters by status
- [ ] Service transforms entity data to MCP protocol format
- [ ] Results cached with 'mcp_server:discovery' tag
- [ ] Permission check before returning prompts
- [ ] Service injected into container with proper dependencies

## Technical Requirements
- Extend existing McpBridgeService or create new PromptDiscoveryService
- Service definition in mcp_server.services.yml
- Constructor injection for entity_type.manager and current_user
- Transform format matches MCP spec from plan
- Cache results using cache.default service
- Clear permission-based approach (no OAuth complexity)

## Input Dependencies
- Task 001: McpPromptConfig entity to load and transform

## Output Artifacts
- mcp_server.permissions.yml (updated)
- Service class (src/PromptDiscoveryService.php or updated McpBridgeService.php)
- mcp_server.services.yml (updated)

## Implementation Notes
MCP protocol format for prompts includes:
- name: from label
- title: optional display name
- description: optional explanation
- arguments: array of {name, description, required}
- messages: array of {role, content: {type, ...}}

Permission check is simple: current_user->hasPermission('access mcp server prompts')

No OAuth or complex authentication - just permission-based access control as specified in plan.
