---
id: 5
group: "testing"
dependencies: [2, 3, 4]
status: "completed"
created: 2025-11-16
skills:
  - functional-testing
  - drupal-backend
---
# Create Comprehensive Functional Test

## Objective
Write ONE functional test class with ONE test method that verifies the complete CRUD workflow, discovery service, and permission checks for MCP prompt configurations.

## Skills Required
- functional-testing: BrowserTestBase, form submissions, assertions, user creation
- drupal-backend: Understanding of entity operations, permissions, discovery patterns

## Acceptance Criteria
- [ ] Test class McpPromptConfigTest in tests/src/Functional/
- [ ] Single test method testPromptCrudWorkflow()
- [ ] Creates user with 'administer mcp prompt configurations' and 'access mcp server prompts'
- [ ] Navigates to /admin/config/services/mcp-server/prompts
- [ ] Creates prompt with basic fields, 2 arguments, 2 messages
- [ ] Verifies prompt appears in list with correct data
- [ ] Edits prompt and changes title, adds message
- [ ] Verifies changes persisted
- [ ] Toggles status (disable then enable)
- [ ] Tests discovery service returns correct data
- [ ] Tests permission blocking for unauthorized users
- [ ] Deletes prompt and verifies removal
- [ ] Test passes with vendor/bin/phpunit

## Technical Requirements
- Extend BrowserTestBase
- Test focuses on module behavior, not framework features
- Use assertSession() for DOM assertions
- Use submitForm() for form interactions
- Test both UI and API (discovery service)
- Cover permission checks explicitly
- Single comprehensive test method per module philosophy

## Input Dependencies
- Task 002: Schema for config export validation
- Task 003: Admin UI for CRUD operations
- Task 004: Discovery service and permissions

## Output Artifacts
- tests/src/Functional/McpPromptConfigTest.php
- Passing test verifying end-to-end workflow

## Implementation Notes
Test structure:
1. Setup: Create admin user, login
2. List page: Navigate and verify empty state
3. Create: Fill form with complex data (arguments, messages), submit
4. Read: Verify in list, check discovery service
5. Update: Edit form, change values, verify persistence
6. Status: Disable/enable, check discovery service respects status
7. Permissions: Logout, verify access denied, test discovery with no permission
8. Delete: Remove prompt, verify gone

Focus on business logic: argument validation, message content types, discovery filtering. Don't test Drupal's form API or entity storage - those are framework features.

Keep messages simple - one text message, one with embedded resource is sufficient to verify content type support.
