---
id: 2
group: "prompt-registration"
dependencies: [1]
status: "completed"
created: 2025-11-17
skills:
  - testing
  - drupal
---

# Verify Prompt Registration and Run Tests

## Objective

Verify that prompt registration works correctly by running existing tests, clearing caches, and confirming prompts appear in MCP protocol responses.

## Skills Required

- **Testing**: Running PHPUnit tests and interpreting results
- **Drupal**: Understanding Drupal caching and cache clearing

## Acceptance Criteria

- [ ] Drupal caches cleared after code changes
- [ ] All existing PHPUnit tests pass
- [ ] Prompts appear when queried (manual verification if possible)
- [ ] No PHP errors or warnings in logs

Use your internal Todo tool to track these and keep on track.

## Technical Requirements

**Commands to run**:

1. Clear Drupal cache (required after factory changes):
   ```bash
   vendor/bin/drush cache:rebuild
   ```

2. Run all MCP server tests:
   ```bash
   vendor/bin/phpunit web/modules/contrib/mcp_server/tests/
   ```

3. Run specific tests that cover prompts:
   ```bash
   vendor/bin/phpunit --filter McpPromptConfigTest web/modules/contrib/mcp_server/tests/
   vendor/bin/phpunit --filter McpServerFunctionalTest web/modules/contrib/mcp_server/tests/
   ```

**Expected outcomes**:
- All tests should pass (they did before, and prompt registration is additive)
- Functional tests exercise full MCP server initialization including prompt registration
- No errors in test output

## Input Dependencies

**Required completion**: Task 1 (prompt registration code must be implemented)

**Existing test files**:
- `tests/src/Unit/McpPromptConfigTest.php` - unit tests for prompt entities
- `tests/src/Functional/McpServerFunctionalTest.php` - end-to-end workflow tests

## Output Artifacts

**Test results**: Confirmation that all tests pass

**Verification**: Prompts registered and accessible through MCP protocol

## Implementation Notes

<details>
<summary>Detailed Verification Steps</summary>

1. **Clear caches first**:
   ```bash
   vendor/bin/drush cache:rebuild
   ```
   This ensures:
   - New factory code is loaded
   - Prompt cache is fresh
   - No stale service definitions

2. **Run full test suite**:
   ```bash
   vendor/bin/phpunit web/modules/contrib/mcp_server/tests/
   ```
   Watch for:
   - All tests passing (green output)
   - No PHP errors or warnings
   - No skipped tests (unless expected)

3. **Check specific prompt-related tests**:
   ```bash
   vendor/bin/phpunit --filter McpPromptConfigTest web/modules/contrib/mcp_server/tests/
   ```
   This verifies:
   - Prompt entity CRUD operations
   - Validation logic
   - Cache tag handling

4. **Run functional tests**:
   ```bash
   vendor/bin/phpunit --filter McpServerFunctionalTest web/modules/contrib/mcp_server/tests/
   ```
   This tests:
   - Full MCP server initialization (exercises factory)
   - Protocol-level interactions
   - Integration between components

5. **Manual verification (if MCP Inspector available)**:
   - Query `prompts/list` endpoint
   - Should return array of enabled prompts
   - Check that prompt names, titles, descriptions match configuration
   - Query `prompts/get` with specific prompt name
   - Should return full prompt definition with messages and arguments

6. **Check Drupal logs for errors**:
   ```bash
   vendor/bin/drush watchdog:show --severity=Error --count=20
   ```
   Look for:
   - No MCP-related errors
   - No factory initialization errors
   - No unexpected exceptions

7. **Verify cache invalidation**:
   - Edit a prompt configuration through admin UI
   - Save changes
   - Check that `mcp_server:discovery` cache tag is invalidated
   - Prompts list should reflect changes immediately

</details>

**Common issues and solutions**:

- **Tests fail with "Service not found" errors**: Cache not cleared properly
  - Solution: Run `vendor/bin/drush cache:rebuild` again

- **Prompts not appearing**: Permission issue or prompts disabled
  - Solution: Check that user has `access mcp server prompts` permission
  - Solution: Verify prompt entities have `status: true` in configuration

- **Handler closure errors**: Incorrect data format returned
  - Solution: Check `getMcpPrompt()` returns array with required keys
  - Solution: Verify prompt configuration entities are valid

**Success indicators**:
- All tests pass with 0 failures, 0 errors
- No warnings in test output
- Prompts accessible through MCP protocol
- Cache invalidation works correctly
