---
id: 2
group: "prompt-handler-factory"
dependencies: [1]
status: "completed"
created: 2025-01-17
skills:
  - php
  - drupal-services
---
# Integrate PromptHandlerFactory into McpServerFactory

## Objective
Modify `McpServerFactory` to use the new `PromptHandlerFactory` service for generating prompt handlers with proper argument signatures.

## Skills Required
- PHP service injection and usage
- Understanding of MCP SDK's Builder API

## Acceptance Criteria
- [ ] `McpServerFactory` constructor updated to inject `PromptHandlerFactory`
- [ ] Prompt registration loop updated to use factory-generated handlers
- [ ] Each prompt gets a handler with parameters matching its configured arguments
- [ ] Existing prompts without arguments continue to work
- [ ] Cache rebuild runs successfully after changes

Use your internal Todo tool to track these and keep on track.

## Technical Requirements

<details>
<summary>Detailed Implementation Specifications</summary>

### Update McpServerFactory Constructor
Add `PromptHandlerFactory` to constructor parameters:
```php
public function __construct(
  private readonly ConfigFactoryInterface $configFactory,
  private readonly McpBridgeService $mcpBridge,
  private readonly LoggerInterface $logger,
  private readonly EventDispatcherInterface $eventDispatcher,
  private readonly FileSessionStore $sessionStore,
  private readonly PromptHandlerFactory $promptHandlerFactory, // ADD THIS
) {}
```

### Update Service Definition
Modify `mcp_server.services.yml`:
```yaml
  mcp_server.factory:
    class: Drupal\mcp_server\McpServerFactory
    arguments:
      - '@config.factory'
      - '@mcp_server.bridge'
      - '@logger.channel.mcp_server'
      - '@event_dispatcher'
      - '@mcp_server.session_store'
      - '@mcp_server.prompt_handler_factory'  # ADD THIS
```

### Update Prompt Registration
Replace the current registration logic (lines 90-98 in `McpServerFactory.php`):
```php
// OLD:
foreach ($enabled_prompts as $prompt_data) {
  $builder->addPrompt(
    handler: fn(array $args = []) => $this->mcpBridge->getMcpPrompt($prompt_data['name'])['messages'] ?? [],
    name: $prompt_data['name'],
    description: $prompt_data['description'] ?? NULL,
  );
}

// NEW:
foreach ($enabled_prompts as $prompt_data) {
  $handler = $this->promptHandlerFactory->createHandler(
    $prompt_data['name'],
    $prompt_data['arguments'] ?? []
  );

  $builder->addPrompt(
    handler: $handler,
    name: $prompt_data['name'],
    description: $prompt_data['description'] ?? NULL,
  );
}
```

</details>

## Input Dependencies
- Completed Task 1: `PromptHandlerFactory` service implementation
- Prompt data structure from `McpBridgeService::getEnabledPrompts()`

## Output Artifacts
- Modified `src/McpServerFactory.php`
- Modified `mcp_server.services.yml`

## Implementation Notes
- **Backward Compatibility**: Prompts without arguments should receive an empty array `[]` to the factory, which should generate a parameterless closure
- **Testing**: After implementation, run `vendor/bin/drush cache:rebuild` to ensure service container updates correctly
- **Validation**: The MCP SDK's `ArrayLoader` will use reflection on the generated handlers to discover arguments
