---
id: 3
group: "testing"
dependencies: [2]
status: "completed"
created: 2025-01-17
completed: 2025-01-17
skills:
  - php
  - phpunit
---
# Add Integration Test for Prompt Arguments

## Objective
Create an integration test that verifies prompt arguments are correctly registered with the MCP SDK and discoverable via the MCP Inspector.

## Skills Required
- PHPUnit testing
- Drupal functional testing

## Acceptance Criteria
- [ ] Test creates a test prompt with multiple arguments (required and optional)
- [ ] Test verifies arguments appear in MCP server's prompt list response
- [ ] Test validates argument metadata (name, description, required flag)
- [ ] Test verifies prompts without arguments still work
- [ ] All tests pass

Use your internal Todo tool to track these and keep on track.

## Technical Requirements

<details>
<summary>Detailed Implementation Specifications</summary>

### Test File Location
Extend existing test: `tests/src/Functional/McpServerFunctionalTest.php`

### Test Method
Add a new test method or extend `testEndToEndWorkflows()`:
```php
/**
 * Tests that prompt arguments are correctly registered.
 */
public function testPromptArgumentsRegistered(): void {
  // Create test prompt with arguments
  $prompt = McpPromptConfig::create([
    'id' => 'test_with_args',
    'label' => 'Test Prompt With Arguments',
    'title' => 'Test Prompt',
    'description' => 'A test prompt',
    'arguments' => [
      ['name' => 'skill_level', 'description' => 'Player skill', 'required' => TRUE],
      ['name' => 'surface', 'description' => 'Court surface', 'required' => FALSE],
    ],
    'messages' => [
      [
        'role' => 'user',
        'content' => [
          ['type' => 'text', 'text' => 'Test message'],
        ],
      ],
    ],
    'status' => TRUE,
  ]);
  $prompt->save();

  // Make request to list prompts endpoint
  $request = new GetPromptRequest(
    id: RequestId::random(),
    name: 'Test Prompt With Arguments'
  );

  $response = $this->sendMcpRequest($request);

  // Verify response includes arguments
  $this->assertNotNull($response);
  $promptData = $response->toArray();

  $this->assertArrayHasKey('arguments', $promptData);
  $this->assertCount(2, $promptData['arguments']);

  // Verify first argument
  $this->assertEquals('skill_level', $promptData['arguments'][0]['name']);
  $this->assertEquals('Player skill', $promptData['arguments'][0]['description']);
  $this->assertTrue($promptData['arguments'][0]['required']);

  // Verify second argument
  $this->assertEquals('surface', $promptData['arguments'][1]['name']);
  $this->assertEquals('Court surface', $promptData['arguments'][1]['description']);
  $this->assertFalse($promptData['arguments'][1]['required']);
}
```

### Additional Test Cases
- Prompt with no arguments (regression test)
- Prompt with only required arguments
- Prompt with only optional arguments

</details>

## Input Dependencies
- Completed Task 2: Integrated `PromptHandlerFactory` in `McpServerFactory`
- Existing MCP functional test infrastructure

## Output Artifacts
- Updated `tests/src/Functional/McpServerFunctionalTest.php` with new test methods

## Implementation Notes
- **Test Isolation**: Ensure test prompts are created fresh for each test and cleaned up afterward
- **MCP Protocol**: The test should make actual MCP protocol requests to verify end-to-end functionality
- **Meaningful Testing**: Focus on integration points - does the SDK correctly parse the generated handler's parameters?
