---
id: 1
group: "schema-and-entity"
dependencies: []
status: "completed"
created: 2025-11-18
skills:
  - drupal-backend
---
# Update Configuration Schema for Label and Machine Name Fields

## Objective
Modify the configuration schema to support separate label and machine_name fields for prompt arguments, replacing the current single name field.

## Skills Required
- Drupal configuration schema (YAML)
- Drupal 11 configuration entity system

## Acceptance Criteria
- [ ] `name` field renamed to `machine_name` in `mcp_server.mcp_prompt.arguments` mapping
- [ ] New `label` field added with type `label`
- [ ] Fields ordered: label, machine_name, description, required, completion_providers
- [ ] Schema validates correctly (no Drupal config schema errors)

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
**File**: `config/schema/mcp_server.schema.yml`

**Current schema section** (`mcp_server.mcp_prompt.arguments` mapping):
```yaml
name:
  type: string
  label: 'Name'
description:
  type: string
  label: 'Description'
required:
  type: boolean
  label: 'Required'
completion_providers:
  type: sequence
  # ...
```

**Target schema structure**:
```yaml
label:
  type: label
  label: 'Label'
machine_name:
  type: string
  label: 'Machine name'
description:
  type: string
  label: 'Description'
required:
  type: boolean
  label: 'Required'
completion_providers:
  type: sequence
  # ...
```

## Input Dependencies
None - this is the foundation task for the feature.

## Output Artifacts
- Modified `config/schema/mcp_server.schema.yml` with updated argument mapping

<details>
<summary>Implementation Notes</summary>

1. **Locate the schema file**: `/var/www/html/web/modules/contrib/mcp_server/config/schema/mcp_server.schema.yml`

2. **Find the arguments mapping**: Search for `mcp_server.mcp_prompt.*` and locate the `arguments` sequence type definition

3. **Modify the mapping**:
   - Change `name:` to `machine_name:`
   - Add new `label:` field above `machine_name:` with type `label`
   - Keep all other fields unchanged

4. **Field order matters**: Ensure the order is label, machine_name, description, required, completion_providers for logical UX flow

5. **Validation**: After changes, clear cache with `vendor/bin/drush cache:rebuild` and check for schema errors

**Example of expected structure**:
```yaml
mcp_server.mcp_prompt.*:
  type: config_entity
  label: 'MCP Prompt configuration'
  mapping:
    # ... other fields ...
    arguments:
      type: sequence
      label: 'Arguments'
      sequence:
        type: mapping
        label: 'Argument'
        mapping:
          label:
            type: label
            label: 'Label'
          machine_name:
            type: string
            label: 'Machine name'
          description:
            type: string
            label: 'Description'
          required:
            type: boolean
            label: 'Required'
          completion_providers:
            # ... existing structure ...
```

**Common pitfalls**:
- Don't change the completion_providers structure
- Ensure YAML indentation is correct (2 spaces)
- The `type: label` is a Drupal schema type for translatable labels
</details>
