---
id: 1
group: "plugin-architecture"
dependencies: []
status: "completed"
created: "2025-11-18"
skills:
  - drupal-backend
  - php
---
# Update Plugin Architecture for Configuration Support

## Objective
Transform completion provider plugins from stateless implementations to fully configurable plugins by updating the interface and base class to extend PluginFormInterface and ConfigurableInterface.

## Skills Required
- drupal-backend: Drupal plugin system, interfaces, configuration patterns
- php: PHP 8.3+ features, inheritance, abstract methods

## Acceptance Criteria
- [ ] PromptArgumentCompletionProviderInterface extends PluginFormInterface and ConfigurableInterface
- [ ] PromptArgumentCompletionProviderBase implements configuration methods
- [ ] All existing completion providers compile without errors
- [ ] Cache rebuild completes successfully

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
- Update `src/Annotation/PromptArgumentCompletionProvider.php` interface
- Update `src/Plugin/PromptArgumentCompletionProviderBase.php` base class
- Follow Drupal plugin configuration patterns
- Use PHP 8.3 constructor property promotion

## Input Dependencies
- Existing plugin interface at `src/Annotation/PromptArgumentCompletionProvider.php`
- Existing base class at `src/Plugin/PromptArgumentCompletionProviderBase.php`
- Reference: MockTracker plugin from ab_tests module for configurable plugin pattern

## Output Artifacts
- Updated interface requiring PluginFormInterface and ConfigurableInterface methods
- Base class providing default implementations for configuration methods
- Abstract method declarations for buildConfigurationForm, validateConfigurationForm, submitConfigurationForm

<details>
<summary>Implementation Notes</summary>

### Interface Changes
In `src/Annotation/PromptArgumentCompletionProvider.php`:
- Extend `PluginFormInterface` from `Drupal\Core\Plugin\PluginFormInterface`
- Extend `ConfigurableInterface` from `Drupal\Component\Plugin\ConfigurableInterface`
- No additional method declarations needed (inherited from extended interfaces)

### Base Class Changes
In `src/Plugin/PromptArgumentCompletionProviderBase.php`:
- Extend `PluginBase` (if not already)
- Implement `ConfigurableInterface` methods:
  - `defaultConfiguration()`: Return empty array `[]`
  - `getConfiguration()`: Return `$this->configuration`
  - `setConfiguration(array $configuration)`: Merge with defaults and store
- Implement `PluginFormInterface` methods as abstract:
  - `abstract public function buildConfigurationForm(array $form, FormStateInterface $form_state)`
  - `abstract public function validateConfigurationForm(array &$form, FormStateInterface $form_state)`
  - `abstract public function submitConfigurationForm(array &$form, FormStateInterface $form_state)`
- Update constructor to initialize configuration with defaults

### Pattern Reference
Follow the pattern from `Drupal\ab_analytics_tracker_example\Plugin\AbAnalytics\MockTracker`:
- Configuration storage in `$this->configuration` property
- Merge pattern: `$this->configuration = NestedArray::mergeDeep($this->defaultConfiguration(), $configuration)`
- Use `$this->t()` for translatable strings

### Validation
After changes:
```bash
cd /var/www/html && vendor/bin/drush cache:rebuild
cd /var/www/html && vendor/bin/phpstan analyse web/modules/contrib/mcp_server/
```

</details>
