---
id: 15
summary: "Consolidate MCP Server configuration menu entries into a single entry with tabbed interface"
created: 2025-11-21
---

# Plan: Consolidate MCP Server Configuration Menu with Tabbed Interface

## Original Work Order

> Each one of the configuration menu entries is floated at the top level Web Services menu. I want to collect them all under a single MCP Server entry. Clicking on this Web Services MCP Server entry will lead to a page with tabs with all of the configuration screens for the MCP Server. The default configuration screen should be the one for resource templates.

## Executive Summary

This plan reorganizes the MCP Server module's administrative interface by consolidating three separate top-level menu entries (MCP Tool Configurations, MCP Prompt Configurations, and MCP Resource Settings) into a single unified "MCP Server" menu entry with a tabbed interface. The resource templates configuration will serve as the default landing page when accessing the MCP Server configuration.

The approach leverages Drupal's local task system (tabs) to create a cleaner, more cohesive administrative experience. This consolidation reduces menu clutter in the Web Services section while maintaining easy access to all configuration screens through tabs.

```mermaid
graph TD
    A[Web Services Menu] --> B[MCP Server]
    B --> C[Resources Tab - Default]
    B --> D[Tools Tab]
    B --> E[Prompts Tab]

    style C fill:#90EE90
    style B fill:#87CEEB
```

## Context

### Current State

The MCP Server module currently exposes three separate configuration pages as individual menu items under Configuration > Web Services:

- **MCP Tool Configurations** (`/admin/config/services/mcp-server/tools`)
- **MCP Prompt Configurations** (`/admin/config/services/mcp-server/prompts`)
- **MCP Resource Settings** (`/admin/config/services/mcp-server/resources`)

Each appears as a distinct top-level entry in the Web Services menu, defined in `mcp_server.links.menu.yml`. This scattered presentation makes the administrative interface feel fragmented and increases visual clutter.

### Target State

A single "MCP Server" menu entry in the Web Services menu that serves as the primary entry point. Clicking this entry leads to the resource templates configuration page, with three tabs available:

1. **Resources** (default tab) - Resource template plugin configuration
2. **Tools** - Tool configuration management
3. **Prompts** - Prompt configuration management

The URL structure remains unchanged (`/admin/config/services/mcp-server/*`), but navigation is streamlined through tabs.

### Background

Drupal's menu and routing system supports two key mechanisms for this:
- **Menu links** (`.links.menu.yml`) - Define menu entries
- **Local tasks** (`.links.task.yml`) - Define tabs on pages

The implementation requires creating a single parent menu link and converting the other configuration pages into local tasks (tabs) of that parent.

## Technical Implementation Approach

```mermaid
graph LR
    A[Update links.menu.yml] --> B[Create links.task.yml]
    B --> C[Update routing.yml]
    C --> D[Clear cache]

    style A fill:#FFE4B5
    style B fill:#FFE4B5
    style C fill:#FFE4B5
    style D fill:#90EE90
```

### Menu Link Consolidation

**Objective**: Replace three separate menu entries with a single "MCP Server" parent entry

Modify `mcp_server.links.menu.yml` to:
- Keep only ONE menu link: `mcp_server.admin` pointing to the resources route
- Remove the three existing individual menu links
- Configure the parent as `system.admin_config_services`
- Set appropriate weight for menu ordering

### Local Task (Tab) Creation

**Objective**: Convert configuration pages into tabs accessible from the main MCP Server page

Create `mcp_server.links.task.yml` to define three local tasks:
- **Resources tab**: Base route, marked as default tab
- **Tools tab**: Links to tools configuration
- **Prompts tab**: Links to prompts configuration

Each tab specifies:
- `route_name`: The corresponding route from routing.yml
- `base_route`: The parent route (resources route)
- `title`: Tab label
- `weight`: Tab ordering (Resources=0, Tools=10, Prompts=20)

### Route Configuration Review

**Objective**: Ensure routing definitions support the tabbed interface

Review `mcp_server.routing.yml` to confirm:
- All three routes exist with correct paths
- Route names match those referenced in local tasks
- No changes needed to existing routes (they remain functional)

## Risk Considerations and Mitigation Strategies

### Technical Risks

- **Cache issues preventing tabs from appearing**: Drupal heavily caches routing and menu data
    - **Mitigation**: Document clear cache rebuild requirement (`drush cache:rebuild`) and include in testing steps

- **Existing bookmarks breaking**: Users may have bookmarked individual configuration URLs
    - **Mitigation**: Existing routes remain functional at same URLs; only menu presentation changes

### Implementation Risks

- **Incorrect base_route configuration**: If local tasks reference wrong base route, tabs won't appear
    - **Mitigation**: Carefully verify base_route matches the resources route name exactly

- **Weight configuration causing unexpected tab order**: Incorrect weights could disorder tabs
    - **Mitigation**: Use clear weight values (0, 10, 20) with adequate spacing for future additions

## Success Criteria

### Primary Success Criteria

1. Web Services menu displays single "MCP Server" entry instead of three separate entries
2. Clicking "MCP Server" menu entry loads the resource templates configuration page by default
3. Three tabs (Resources, Tools, Prompts) are visible on all three configuration pages
4. Tab navigation works correctly, loading the appropriate configuration screen

### Quality Assurance Metrics

1. All existing functionality of configuration pages remains intact
2. Direct URL access to each configuration page still works
3. Cache rebuild successfully activates the new menu structure
4. No PHP errors or warnings in logs during navigation

## Resource Requirements

### Development Skills

- Drupal menu and routing system understanding
- YAML configuration file syntax
- Drupal cache management

### Technical Infrastructure

- Drupal 11.1 development environment
- Access to Drush for cache clearing
- Module file modification capabilities

## Implementation Order

1. Create local tasks file defining tabs
2. Modify menu links file to consolidate menu entries
3. Verify routing file requires no changes
4. Clear cache and test navigation
5. Validate all configuration screens remain functional

## Task Dependencies

```mermaid
graph TD
    001[Task 001: Create Local Tasks File] --> 003[Task 003: Test and Validate]
    002[Task 002: Update Menu Links File] --> 003

    style 001 fill:#FFE4B5
    style 002 fill:#FFE4B5
    style 003 fill:#90EE90
```

## Execution Blueprint

**Validation Gates:**
- Reference: `.ai/task-manager/config/hooks/POST_PHASE.md`

### ✅ Phase 1: Configuration Files Setup
**Parallel Tasks:**
- ✔️ Task 001: Create Local Tasks File (status: completed)
- ✔️ Task 002: Update Menu Links File (status: completed)

**Objective**: Create and modify the necessary YAML configuration files to establish the tabbed navigation structure.

### ✅ Phase 2: Validation and Testing
**Parallel Tasks:**
- ✔️ Task 003: Test and Validate (depends on: 001, 002) (status: completed)

**Objective**: Verify the consolidated menu structure works correctly and all configuration pages remain accessible.

### Execution Summary
- Total Phases: 2
- Total Tasks: 3
- Maximum Parallelism: 2 tasks (in Phase 1)
- Critical Path Length: 2 phases

## Execution Summary

**Status**: ✅ Completed Successfully
**Completed Date**: 2025-11-21

### Results

Successfully consolidated the MCP Server module's administrative interface from three separate menu entries into a single unified entry with tabbed navigation. Key deliverables:

1. **Created mcp_server.links.task.yml**: Defines three local tasks (tabs) for Resources, Tools, and Prompts configuration pages
2. **Updated mcp_server.links.menu.yml**: Replaced three menu entries with single "MCP Server" entry pointing to Resources as default
3. **Validated implementation**: All linting checks passed, cache cleared successfully, no new errors in logs

The implementation maintains backwards compatibility - all existing routes and URLs remain functional. The only change is the menu presentation and addition of tabbed navigation.

### Noteworthy Events

- **Task dependency correction**: Initially Task 2 was incorrectly configured with a dependency on Task 1. Corrected to reflect that both tasks modify independent files and can execute in parallel.
- **Pre-existing errors**: Found unrelated errors in logs from Nov 20 regarding prompt registration. These are outside the scope of this plan.
- **Automated validation**: All pre-commit hooks (PHPCS, PHPStan, ESLint, Prettier, Stylelint, CSpell) passed successfully.

### Recommendations

1. **Manual UI testing**: While automated validation passed, manual browser testing is recommended to verify:
   - Menu entry displays correctly in Web Services menu
   - All three tabs appear and function properly
   - Tab navigation works across all three configuration pages
   - Default landing on Resources tab is correct

2. **Documentation update**: Consider updating any user documentation or help text that references the old separate menu entries.

3. **User communication**: If this module has active users, notify them of the improved navigation structure in release notes.
