---
id: 1
group: "menu-consolidation"
dependencies: []
status: "completed"
created: 2025-11-21
skills:
  - drupal-routing
  - yaml
---
# Create Local Tasks File for Tab Navigation

## Objective

Create `mcp_server.links.task.yml` to define three tabs (Resources, Tools, Prompts) that will appear on all MCP Server configuration pages, establishing the tabbed interface navigation structure.

## Skills Required

- **Drupal routing**: Understanding of Drupal's local task system and base route configuration
- **YAML**: Proper YAML syntax for Drupal configuration files

## Acceptance Criteria

- [ ] File `mcp_server.links.task.yml` created in module root
- [ ] Three local task definitions created: Resources, Tools, Prompts
- [ ] Resources tab configured as default tab (weight: 0)
- [ ] All tabs reference correct route names from routing.yml
- [ ] All tabs use correct base_route (resources route)
- [ ] Tab weights set appropriately (Resources=0, Tools=10, Prompts=20)

Use your internal Todo tool to track these and keep on track.

## Technical Requirements

The file must define local tasks using Drupal's local task system. Each task requires:
- `route_name`: The route to link to
- `base_route`: The parent route where tabs appear
- `title`: Tab label text
- `weight`: Display order

The base route should be `mcp_server.resource_plugin_settings` (the resources configuration route).

## Input Dependencies

- Existing route names from `mcp_server.routing.yml`:
  - `mcp_server.resource_plugin_settings`
  - `entity.mcp_tool_config.collection`
  - `entity.mcp_prompt_config.collection`

## Output Artifacts

- `/var/www/html/web/modules/contrib/mcp_server/mcp_server.links.task.yml` file defining three tabs

## Implementation Notes

<details>
<summary>Detailed Implementation Guide</summary>

Create the file with this structure:

```yaml
mcp_server.resources:
  route_name: mcp_server.resource_plugin_settings
  base_route: mcp_server.resource_plugin_settings
  title: 'Resources'
  weight: 0

mcp_server.tools:
  route_name: entity.mcp_tool_config.collection
  base_route: mcp_server.resource_plugin_settings
  title: 'Tools'
  weight: 10

mcp_server.prompts:
  route_name: entity.mcp_prompt_config.collection
  base_route: mcp_server.resource_plugin_settings
  title: 'Prompts'
  weight: 20
```

**Key points:**
- The `base_route` must be identical for all three tabs
- The Resources tab has `route_name` matching `base_route`, making it the default
- Weight determines tab order (lower = leftmost)
- Use consistent spacing (10) between weights for future additions

**After creating the file**, a cache rebuild will be required for tabs to appear (handled in a separate task).
</details>
