---
id: 2
group: "menu-consolidation"
dependencies: []
status: "completed"
created: 2025-11-21
skills:
  - drupal-routing
  - yaml
---
# Update Menu Links to Single MCP Server Entry

## Objective

Modify `mcp_server.links.menu.yml` to replace three separate menu entries with a single "MCP Server" entry that points to the resources configuration page.

## Skills Required

- **Drupal routing**: Understanding of Drupal menu system and parent-child relationships
- **YAML**: Proper YAML syntax for menu link definitions

## Acceptance Criteria

- [ ] File `mcp_server.links.menu.yml` updated to contain single menu link
- [ ] Menu link titled "MCP Server"
- [ ] Menu link points to `mcp_server.resource_plugin_settings` route
- [ ] Parent set to `system.admin_config_services` (Web Services menu)
- [ ] Appropriate weight configured for menu ordering
- [ ] Previous three menu links removed

Use your internal Todo tool to track these and keep on track.

## Technical Requirements

The menu link definition requires:
- Unique machine name (e.g., `mcp_server.admin`)
- `title`: Display text in menu
- `description`: Tooltip/help text
- `parent`: Parent menu item
- `route_name`: The route to link to
- `weight`: Menu item ordering

## Input Dependencies

- Route name `mcp_server.resource_plugin_settings` from `mcp_server.routing.yml`
- Independent of Task 1 (modifies different file)

## Output Artifacts

- Updated `/var/www/html/web/modules/contrib/mcp_server/mcp_server.links.menu.yml`

## Implementation Notes

<details>
<summary>Detailed Implementation Guide</summary>

Replace the entire contents of `mcp_server.links.menu.yml` with:

```yaml
mcp_server.admin:
  title: 'MCP Server'
  description: 'Configure MCP Server tools, prompts, and resource templates'
  parent: system.admin_config_services
  route_name: mcp_server.resource_plugin_settings
  weight: 10
```

**What's changing:**
- **Before**: Three menu links (`mcp_server.tool_configs`, `mcp_server.prompt_configs`, `mcp_server.resource_configs`)
- **After**: Single menu link (`mcp_server.admin`)

**Why this works:**
- The single menu link points to the resources page
- The local tasks (tabs) created in Task 1 will automatically appear
- All three configuration pages remain accessible via tabs
- URL paths remain unchanged

**Weight consideration:**
- `weight: 10` places this entry in a reasonable position within Web Services menu
- Adjust if needed based on surrounding menu items

**After updating the file**, a cache rebuild will be required (handled in separate task).
</details>
