---
id: 3
group: "menu-consolidation"
dependencies: [1, 2]
status: "completed"
created: 2025-11-21
skills:
  - drupal-testing
  - manual-testing
---
# Test and Validate Tabbed Navigation

## Objective

Clear Drupal cache, manually test the tabbed navigation interface, and validate that all configuration pages are accessible and functional through the new menu structure.

## Skills Required

- **Drupal testing**: Understanding of cache management and manual UI testing
- **Manual testing**: Systematic verification of navigation and functionality

## Acceptance Criteria

- [ ] Cache cleared successfully using drush
- [ ] Web Services menu shows single "MCP Server" entry (not three separate entries)
- [ ] Clicking "MCP Server" loads resource templates configuration page
- [ ] Three tabs visible: Resources, Tools, Prompts
- [ ] Resources tab active by default
- [ ] Clicking Tools tab navigates to tools configuration
- [ ] Clicking Prompts tab navigates to prompts configuration
- [ ] All tabs visible on all three configuration pages
- [ ] Direct URL access still works for all three pages
- [ ] No PHP errors or warnings in logs

Use your internal Todo tool to track these and keep on track.

## Technical Requirements

- Access to drush command: `vendor/bin/drush cache:rebuild`
- Access to Drupal admin interface at `/admin/config/services`
- Ability to check Drupal logs for errors

## Input Dependencies

- Task 1: Local tasks file created
- Task 2: Menu links file updated

## Output Artifacts

- Validated, working tabbed navigation interface
- No errors in Drupal logs

## Implementation Notes

<details>
<summary>Detailed Testing Guide</summary>

### Step 1: Clear Cache

```bash
cd /var/www/html
vendor/bin/drush cache:rebuild
```

**Why this is critical**: Drupal caches routing, menu, and local task definitions. Changes won't appear without cache rebuild.

### Step 2: Visual Verification

Navigate to: `/admin/config/services`

**Expected result**:
- Single menu entry: "MCP Server"
- Description: "Configure MCP Server tools, prompts, and resource templates"
- No longer see: "MCP Tool Configurations", "MCP Prompt Configurations", "MCP Resource Settings" as separate entries

### Step 3: Tab Navigation Testing

**Test 1**: Click "MCP Server" menu entry
- URL should be: `/admin/config/services/mcp-server/resources`
- Page should show resource template configuration
- Three tabs should be visible at top: Resources | Tools | Prompts
- Resources tab should be active (highlighted)

**Test 2**: Click "Tools" tab
- URL should change to: `/admin/config/services/mcp-server/tools`
- Page should show tools configuration list
- Tools tab should now be active
- Resources and Prompts tabs still visible

**Test 3**: Click "Prompts" tab
- URL should change to: `/admin/config/services/mcp-server/prompts`
- Page should show prompts configuration list
- Prompts tab should now be active
- Resources and Tools tabs still visible

### Step 4: Direct URL Access

Test each URL directly in browser:
- `/admin/config/services/mcp-server/resources` - Should work, show tabs
- `/admin/config/services/mcp-server/tools` - Should work, show tabs
- `/admin/config/services/mcp-server/prompts` - Should work, show tabs

### Step 5: Functionality Testing

On each configuration page, verify:
- Forms render correctly
- Buttons work (Add, Edit, Delete)
- Configuration can be saved
- No visual glitches or layout issues

### Step 6: Error Checking

Check Drupal logs:
```bash
vendor/bin/drush watchdog:show --severity=Error --count=20
```

**Expected**: No new errors related to menu, routing, or local tasks.

### Troubleshooting

If tabs don't appear:
- Verify `base_route` in links.task.yml matches exactly
- Clear cache again
- Check file permissions on .links.task.yml file

If menu entry doesn't update:
- Clear cache again
- Verify YAML syntax is correct (no tabs, proper indentation)
- Check route name in links.menu.yml exists in routing.yml

If errors occur:
- Check recent log entries: `drush watchdog:show --count=50`
- Review YAML files for syntax errors
- Verify file locations are correct
</details>
