---
id: 4
group: database-session-management
dependencies:
  - 1
  - 2
  - 3
status: completed
created: '2025-11-25'
skills:
  - drupal-backend
---
# Update Service Configuration and Remove JWT Services

## Objective
Update `mcp_server.services.yml` to register database session services, remove JWT-based services, and update all service dependencies.

## Skills Required
- **drupal-backend**: Drupal service container, service definitions, dependency injection

## Acceptance Criteria
- [ ] `mcp_server.db_session_manager` service registered
- [ ] `mcp_server.database_session_store` service registered
- [ ] `mcp_server.jwt_session_manager` service removed
- [ ] `mcp_server.controller.mcp_server` uses `db_session_manager`
- [ ] `mcp_server.session_store` alias points to `database_session_store`
- [ ] Config schema updated: `session.jwt_ttl` renamed to `session.ttl`
- [ ] All service dependencies updated correctly

## Technical Requirements

### Update mcp_server.services.yml

Location: `mcp_server.services.yml`

#### Add Database Session Services

```yaml
  mcp_server.db_session_manager:
    class: Drupal\mcp_server\Session\DbSessionManager
    arguments:
      - '@database'
      - '@config.factory'
      - '@logger.channel.mcp_server'

  mcp_server.database_session_store:
    class: Drupal\mcp_server\Session\DatabaseSessionStore
    arguments:
      - '@database'
      - '@config.factory'
      - '@logger.channel.mcp_server'
```

#### Remove JWT Session Service

Delete the entire `mcp_server.jwt_session_manager` service definition.

#### Update Controller Dependency

Change the controller service definition:

```yaml
  mcp_server.controller.mcp_server:
    class: Drupal\mcp_server\Controller\McpServerController
    arguments:
      # ... other arguments ...
      - '@mcp_server.db_session_manager'  # Changed from jwt_session_manager
      # ... other arguments ...
```

#### Update Session Store Alias

If there's a `mcp_server.session_store` alias, update it:

```yaml
  mcp_server.session_store:
    alias: mcp_server.database_session_store
```

If the alias doesn't exist, create it.

### Update Config Schema

Location: `config/schema/mcp_server.schema.yml`

Update the session configuration section:

**Before:**
```yaml
    session:
      type: mapping
      label: 'Session configuration'
      mapping:
        jwt_ttl:
          type: integer
          label: 'JWT session TTL in seconds'
          description: 'Time-to-live for JWT session tokens (default: 86400 = 24 hours)'
        issuer:
          type: string
          label: 'JWT issuer'
          description: 'Issuer claim for JWT tokens (defaults to site base URL)'
```

**After:**
```yaml
    session:
      type: mapping
      label: 'Session configuration'
      mapping:
        ttl:
          type: integer
          label: 'Session TTL in seconds'
          description: 'Time-to-live for MCP sessions (default: 86400 = 24 hours)'
```

Remove the `issuer` field entirely.

### Update Default Configuration

Location: `config/install/mcp_server.settings.yml`

Update session configuration:

**Before:**
```yaml
session:
  jwt_ttl: 86400
  issuer: ''
```

**After:**
```yaml
session:
  ttl: 86400
```

## Input Dependencies
- Task 1: `DbSessionManager` and `DatabaseSessionStore` classes must exist
- Task 2: `SessionContext` refactored
- Task 3: `McpServerController` updated to use `DbSessionManager`

## Output Artifacts
- Updated `mcp_server.services.yml`
- Updated `config/schema/mcp_server.schema.yml`
- Updated `config/install/mcp_server.settings.yml`
- JWT services removed
- Database session services registered

## Implementation Notes

<details>
<summary>Detailed Implementation Guide</summary>

### Service Registration Order

Services can be defined in any order in the YAML file. Drupal's service container handles dependency resolution.

### Service Arguments Order

Ensure argument order matches constructor parameter order in:
- `DbSessionManager::__construct()`
- `DatabaseSessionStore::__construct()`
- `McpServerController::__construct()`

### Config Migration

**DO NOT create an update hook** for config migration. This is intentional:
- Module is in active development
- Not yet released
- Developers can manually update config or reinstall module

### Verifying Service Registration

After making changes, run:
```bash
vendor/bin/drush cache:rebuild
vendor/bin/drush debug:container mcp_server.db_session_manager
vendor/bin/drush debug:container mcp_server.database_session_store
```

Should show the service definitions without errors.

### Coordinator Services

Check if `SamplingCoordinator` and `ElicitationCoordinator` are registered as services. If they are, they likely don't need updates since they receive `SessionContext` as method parameters, not constructor injection.

### Service Alias Strategy

Using `mcp_server.session_store` as an alias provides flexibility:
- Other code can depend on the abstract concept of "session store"
- We can swap implementations without updating dependent services
- Follows Drupal best practices for interface-based dependency injection

</details>
