---
id: 1
group: "infrastructure-removal"
dependencies: []
status: "completed"
created: 2025-11-27
skills:
  - php
  - drupal
---
# Remove Obsolete Sampling/Elicitation Infrastructure

## Objective

Delete all custom sampling, elicitation, streaming, and pending request infrastructure that becomes obsolete with the SDK migration.

## Skills Required

- PHP file management
- Drupal service configuration (services.yml)
- Drupal database schema (install file)

## Acceptance Criteria

- [x] All Sampling classes removed: `SamplingCoordinator.php`, `SamplingInstruction.php`, `SamplingResponse.php`, `StreamingResult.php`
- [x] All Elicitation classes removed: `ElicitationCoordinator.php`, `ElicitationPrompt.php`, `ElicitationResponse.php`
- [x] All Streaming classes removed: `StreamingResult.php`, `StreamingResponseEmitter.php`
- [x] All PendingRequest classes removed: `PendingRequestId.php`, `PendingRequestRepository.php`, `RequestEnvelope.php`, `ResponseEnvelope.php`
- [x] Empty directories (`src/Sampling/`, `src/Elicitation/`, `src/Streaming/`, `src/PendingRequest/`) removed
- [x] Related service definitions removed from `mcp_server.services.yml`
- [x] Database schema `mcp_pending_request` removed from `mcp_server.install`
- [x] Obsolete tests removed
- [x] No PHP syntax errors after removal
- [x] PHPStan passes on remaining code

## Technical Requirements

Files deleted:
- `src/Sampling/SamplingCoordinator.php`
- `src/Sampling/SamplingInstruction.php`
- `src/Sampling/SamplingResponse.php`
- `src/Sampling/StreamingResult.php`
- `src/Elicitation/ElicitationCoordinator.php`
- `src/Elicitation/ElicitationPrompt.php`
- `src/Elicitation/ElicitationResponse.php`
- `src/Streaming/StreamingResult.php`
- `src/Streaming/StreamingResponseEmitter.php`
- `src/PendingRequest/PendingRequestId.php`
- `src/PendingRequest/PendingRequestRepository.php`
- `src/PendingRequest/RequestEnvelope.php`
- `src/PendingRequest/ResponseEnvelope.php`

## Input Dependencies

None - this is the first task

## Output Artifacts

- Clean codebase with only SDK-compatible code remaining
- Updated `mcp_server.services.yml` without obsolete services
- Updated `mcp_server.install` without obsolete schema

## Implementation Notes

This task was completed during a previous execution. ~2,500 lines of code were eliminated including 18 files and 5 empty directories.
