---
id: 1
group: "tool-implementation"
dependencies: []
status: "completed"
created: 2025-11-28
skills:
  - drupal-backend
---
# Implement ArticleSummaryTool Plugin

## Objective
Create a Tool API plugin that accepts a full URL, resolves it to an article node, extracts the body content, uses MCP sampling to generate a summary, and stores the result in the body.summary field.

## Skills Required
- drupal-backend: Drupal Tool API plugin development, entity system, path alias resolution

## Acceptance Criteria
- [ ] Tool class `ArticleSummaryTool` created in `tests/modules/mcp_server_test/src/Plugin/tool/Tool/`
- [ ] Tool accepts a `url` string input parameter
- [ ] Tool parses URL and extracts path component
- [ ] Tool resolves path alias to internal path using `AliasManagerInterface`
- [ ] Tool validates the path is `/node/{id}` format
- [ ] Tool loads node entity and validates it's an `article` bundle
- [ ] Tool validates body field exists and has content
- [ ] Tool implements `ClientGatewayAwareInterface` and uses `McpToolSamplingTrait`
- [ ] Tool calls LLM sampling with body content to generate summary
- [ ] Tool stores LLM response in `body.summary` field
- [ ] Tool saves the node entity
- [ ] Tool returns success with generated summary or descriptive error messages
- [ ] Code follows existing patterns from `SamplingTestTool` and `ExampleTool`
- [ ] Code passes phpcs and phpstan checks

Use your internal Todo tool to track these and keep on track.

## Technical Requirements
- PHP 8.3+ with strict types
- Drupal Tool API plugin via `#[Tool]` attribute
- `ClientGatewayAwareInterface` for MCP sampling capability
- `McpToolSamplingTrait` for simplified sampling calls
- `AliasManagerInterface` for path alias resolution
- Entity Type Manager for node loading
- `ToolOperation::Update` since the tool modifies entity data
- Tool ID: `mcp_server_test:article_summary`

## Input Dependencies
None - this is the first and only task

## Output Artifacts
- `tests/modules/mcp_server_test/src/Plugin/tool/Tool/ArticleSummaryTool.php`

## Implementation Notes
- Follow the pattern established by `SamplingTestTool.php` for sampling integration
- Follow the pattern from `ExampleTool.php` for input definitions and access control
- Use `parse_url()` to extract path from URL
- Use `\Drupal::service('path_alias.manager')` for alias resolution
- Use `\Drupal::entityTypeManager()->getStorage('node')->load()` for entity loading
- Set body summary via `$node->body->summary = $generated_summary`
- Use reasonable max_tokens (500-1000) for summary generation
- Handle errors gracefully with descriptive `ExecutableResult::failure()` messages
