# MCP Server Module - Agent Guidelines

**CRITICAL**: this module is still in active development and has not been released yet. Do not add any backwards compatibility layers, or migrations, in any of your solutions.

## Build/Test Commands

- **Run all tests**: `cd /var/www/html && vendor/bin/phpunit web/modules/contrib/mcp_server/tests/`
- **Run single test**: `cd /var/www/html && vendor/bin/phpunit --filter TestClassName web/modules/contrib/mcp_server/tests/`
- **Lint code**: `cd /var/www/html && vendor/bin/phpcs --standard=Drupal,DrupalPractice web/modules/contrib/mcp_server/`
- **Static analysis**: `cd /var/www/html && vendor/bin/phpstan analyse web/modules/contrib/mcp_server/`
- **Clear cache**: `cd /var/www/html && vendor/bin/drush cache:rebuild`

## Code Style (PHP 8.3+)

- **Strict types**: Always use `declare(strict_types=1);`
- **Classes**: Prefer `final` classes; use constructor property promotion with `readonly` where possible
- **Variables**: `snake_case` for locals/parameters, `lowerCamelCase` for class properties
- **Guard clauses**: Use early returns to reduce nesting; avoid deep conditionals
- **Array operations**: Use `array_filter()`, `array_map()`, `array_reduce()` over `foreach` with conditionals
- **Type hints**: Full type declarations; avoid `@var` comments (use conditionals for refinement)
- **Comments**: Explain _why_, not _what_ or _how_; 80-char limit in comments
- **Getters/Setters**: Avoid; use `public readonly` for read-only, `public` for read-write
- **Data objects**: Favor plain data objects over keyed arrays for better DX
- **Error handling**: Use specific exception classes; never suppress errors in production code
- **Testing**: Test business logic only, not framework features; green tests must mean working code

**CRITICAL**: NEVER use `eval()` or have the code generate strings with code during runtime in order to integrate with `mcp/sdk` or for any other purpose.

## Testing Philosophy

### Core Principle

**Test what your module does, not what the framework does.**

If a test would pass or fail regardless of your module's code, it's testing the framework, not your module. Framework tests belong in the framework's test suite.

### Scope Guidelines

**Test module-specific logic:**

- Custom validation, computation, or transformation logic written in this module
- Integration between services where module-specific behavior occurs
- Business rules and workflows unique to this module's purpose

**Do NOT test framework behavior:**

- Base class functionality inherited from framework parent classes
- Standard framework APIs that work the same way for all modules
- Language features or standard library behavior
- Framework subsystems (storage, cache, routing, etc.) that aren't modified by this module

**Ask yourself:** "If the framework implementation changes but maintains the same contract, would this test still be relevant to my module?" If no, you're testing the framework.

### Performance Considerations

Expensive test setup (database, HTTP stack, full bootstrap) should be minimized:

- Consolidate test scenarios to reduce expensive setup repetition
- Prefer helper methods over additional test methods when they share expensive setup
- Only allow ONE Functional and FunctionalJavaScript test per module.
- Only allow ONE test function for each Functional and FunctionalJavaScript test classes. Use helper methods inside.
