<?php

declare(strict_types=1);

namespace Drupal\mcp_server\Attribute;

use Drupal\Component\Plugin\Attribute\AttributeBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a Prompt Argument Completion Provider attribute.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
final class PromptArgumentCompletionProvider extends AttributeBase {

  /**
   * Constructs a PromptArgumentCompletionProvider attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The human-readable name.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $description
   *   The description.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly TranslatableMarkup $description,
  ) {}

}
