<?php

declare(strict_types=1);

namespace Drupal\mcp_server\Attribute;

use Drupal\Component\Plugin\Attribute\AttributeBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a Resource Template attribute.
 *
 * Resource Template plugins expose Drupal data as MCP resources with
 * URI-based access patterns and proper access control.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
final class ResourceTemplate extends AttributeBase {

  /**
   * Constructs a ResourceTemplate attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The human-readable label.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $description
   *   The description.
   * @param array $module_dependencies
   *   Array of module machine names this resource depends on.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly TranslatableMarkup $description,
    public readonly array $module_dependencies = [],
  ) {}

}
