<?php

declare(strict_types=1);

namespace Drupal\mcp_server\Capability\Loader;

use Mcp\Capability\Completion\ProviderInterface;

/**
 * Chains multiple completion providers for a single argument.
 */
final class ChainedCompletionProvider implements ProviderInterface {

  /**
   * Constructs a new object.
   *
   * @param array<int, \Mcp\Capability\Completion\ProviderInterface> $providers
   *   Providers configured for an argument in the order they should execute.
   */
  public function __construct(
    private readonly array $providers,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function getCompletions(string $currentValue): array {
    $completions = [];

    foreach ($this->providers as $provider) {
      $completions = [
        ...$completions,
        ...$provider->getCompletions($currentValue),
      ];
    }

    return $completions;
  }

}
