<?php

declare(strict_types=1);

namespace Drupal\mcp_server\Capability\Loader;

use Drupal\mcp_server\Plugin\PromptArgumentCompletionProviderInterface;
use Mcp\Capability\Completion\ProviderInterface;

/**
 * Adapts Drupal completion provider plugins to MCP SDK ProviderInterface.
 */
final class PluginProviderAdapter implements ProviderInterface {

  /**
   * Constructs a PluginProviderAdapter.
   *
   * @param \Drupal\mcp_server\Plugin\PromptArgumentCompletionProviderInterface $plugin
   *   The Drupal plugin instance.
   * @param array $configuration
   *   The plugin configuration.
   */
  public function __construct(
    private readonly PromptArgumentCompletionProviderInterface $plugin,
    private readonly array $configuration,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function getCompletions(string $currentValue): array {
    return $this->plugin->getCompletions($currentValue, $this->configuration);
  }

}
