<?php

declare(strict_types=1);

namespace Drupal\mcp_server;

use Mcp\Server\ClientGateway;

/**
 * Interface for MCP tools that require access to the ClientGateway.
 *
 * Tools implementing this interface will receive a ClientGateway instance
 * before execution, allowing them to communicate with the MCP client
 * (e.g., for sampling requests).
 *
 * Use the McpToolSamplingTrait for a convenient implementation.
 *
 * @see \Drupal\mcp_server\Traits\McpToolSamplingTrait
 */
interface ClientGatewayAwareInterface {

  /**
   * Sets the client gateway for sampling requests.
   *
   * @param \Mcp\Server\ClientGateway $gateway
   *   The client gateway instance.
   */
  public function setClientGateway(ClientGateway $gateway): void;

}
