<?php

declare(strict_types=1);

namespace Drupal\mcp_server\Exception;

/**
 * Exception thrown when OAuth scopes are insufficient for a tool.
 */
final class InsufficientScopeException extends \RuntimeException {

  /**
   * Constructs an InsufficientScopeException.
   *
   * @param string $message
   *   The exception message.
   * @param string $toolName
   *   The name of the tool requiring scopes.
   * @param array $requiredScopes
   *   The array of required OAuth scopes.
   * @param array $missingScopes
   *   The array of missing OAuth scopes.
   * @param array $currentScopes
   *   The array of currently granted OAuth scopes.
   * @param int $code
   *   The exception code.
   * @param \Throwable|null $previous
   *   The previous throwable for chaining.
   */
  public function __construct(
    string $message,
    public readonly string $toolName,
    public readonly array $requiredScopes,
    public readonly array $missingScopes,
    public readonly array $currentScopes,
    int $code = 0,
    ?\Throwable $previous = NULL,
  ) {
    parent::__construct($message, $code, $previous);
  }

  /**
   * Gets structured error data for JSON-RPC error responses.
   */
  public function getErrorData(): array {
    return [
      'tool' => $this->toolName,
      'required_scopes' => $this->requiredScopes,
      'missing_scopes' => $this->missingScopes,
      'current_scopes' => $this->currentScopes,
    ];
  }

}
