<?php

declare(strict_types=1);

namespace Drupal\mcp_server;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of MCP Prompt Configuration entities.
 */
final class McpPromptConfigListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header['label'] = $this->t('Prompt Name');
    $header['title'] = $this->t('Title');
    $header['description'] = $this->t('Description');
    $header['status'] = $this->t('Status');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    /** @var \Drupal\mcp_server\Entity\McpPromptConfig $entity */
    $row['label'] = $entity->label();
    $row['title'] = $entity->getTitle() ?? '';
    $row['description'] = $entity->getDescription() ?? '';
    $row['status'] = $entity->status() ? $this->t('Enabled') : $this->t('Disabled');
    return $row + parent::buildRow($entity);
  }

}
