<?php

declare(strict_types=1);

namespace Drupal\mcp_server;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Service provider for MCP Server integration.
 *
 * This service provider uses dynamic tool discovery based on configuration
 * entities (McpToolConfig) rather than annotation-based discovery.
 * The McpBridgeService provides all MCP tools by reading enabled
 * configuration entities that reference Tool API tools.
 */
final class McpServerServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container): void {
    if (!$container->hasDefinition('mcp_server.server.builder')) {
      return;
    }

    if (!$container->hasDefinition('mcp_server.bridge')) {
      return;
    }

    // Inject the MCP Bridge Service directly into the server builder.
    // The bridge service provides all tools dynamically from config entities.
    $container
      ->getDefinition('mcp_server.server.builder')
      ->addMethodCall('setMcpBridge', [new Reference('mcp_server.bridge')]);
  }

}
