<?php

declare(strict_types=1);

namespace Drupal\mcp_server;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of MCP Tool Configuration entities.
 */
final class McpToolConfigListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header['label'] = $this->t('MCP Tool Name');
    $header['tool_id'] = $this->t('Tool ID');
    $header['authentication_mode'] = $this->t('Authentication');
    $header['status'] = $this->t('Status');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    /** @var \Drupal\mcp_server\Entity\McpToolConfig $entity */
    $row['label'] = $entity->label();
    $row['tool_id'] = $entity->getToolId();
    $row['authentication_mode'] = ucfirst($entity->getAuthenticationMode());
    $row['status'] = $entity->status() ? $this->t('Enabled') : $this->t('Disabled');
    return $row + parent::buildRow($entity);
  }

}
