<?php

declare(strict_types=1);

namespace Drupal\mcp_server\Plugin;

use Drupal\Component\Plugin\ConfigurableInterface;
use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Plugin\PluginFormInterface;

/**
 * Interface for Prompt Argument Completion Provider plugins.
 */
interface PromptArgumentCompletionProviderInterface extends PluginInspectionInterface, ConfigurableInterface, PluginFormInterface {

  /**
   * Get completions for a given current value.
   *
   * @param string $current_value
   *   The current value to get completions for.
   * @param array $configuration
   *   Plugin configuration from the prompt argument.
   *
   * @return string[]
   *   Array of completion values.
   */
  public function getCompletions(string $current_value, array $configuration): array;

}
