<?php

declare(strict_types=1);

namespace Drupal\mcp_server\Service;

/**
 * Value object for scope validation results.
 *
 * This readonly value object encapsulates the result of OAuth scope validation,
 * providing detailed information about whether the validation succeeded and
 * which scopes were required, missing, or present in the token.
 */
final readonly class ScopeValidationResult {

  /**
   * Constructs a new ScopeValidationResult.
   *
   * @param bool $isValid
   *   TRUE if all required scopes are present in the token scopes.
   * @param array $missingScopes
   *   Array of scope IDs that are required but missing from the token.
   * @param array $requiredScopes
   *   Array of all scope IDs that were required for validation.
   * @param array $tokenScopes
   *   Array of scope IDs that are present in the access token.
   */
  public function __construct(
    public bool $isValid,
    public array $missingScopes,
    public array $requiredScopes,
    public array $tokenScopes,
  ) {}

}
